import * as React from 'react'
import { MultipleSelectFieldItem } from './MultipleSelectField'
import { CheckboxListItem } from '../CheckboxListItem'

export interface CheckboxListMenuItemProps {
  item: MultipleSelectFieldItem,
  checked: boolean,
  onToggleCheck (checked: boolean, item: MultipleSelectFieldItem): void
}

export class CheckboxListMenuItem extends React.PureComponent<CheckboxListMenuItemProps> {

  constructor (props: CheckboxListMenuItemProps) {
    super(props)
    this.onToggleCheck = this.onToggleCheck.bind(this)
  }

  render () {
    const { item, checked } = this.props
    return <CheckboxListItem
      id={item.id}
      key={item.id}
      label={item.label}
      checked={checked}
      onToggleCheck={this.onToggleCheck}
    />
  }

  private onToggleCheck (checked: boolean, event: Event) {
    if (this.props.onToggleCheck) this.props.onToggleCheck(checked, this.props.item)
  }
}
