import * as React from 'react'
import Checkbox from 'react-md/lib/SelectionControls/Checkbox'
import ListItemControl from 'react-md/lib/Lists/ListItemControl'

export interface CheckboxListItemProps {
  id: string
  label: string
  checked: boolean
  onToggleCheck (checked: boolean, event: Event): void
}
export let CheckboxListItem: React.SFC<CheckboxListItemProps> = function CheckboxListItem ({ id, label, checked, onToggleCheck }) {
  const checkbox = <Checkbox
    id={id}
    name='list-item-control'
    label={label}
    onChange={onToggleCheck}
    checked={checked || false}
  />
  return <ListItemControl primaryAction={checkbox}/>
}
