unit ituCadastroBasicoV4;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Buttons, JvGradient, utuFactory,
  StdCtrls, ActnList, JvExControls, JvComponent, JvSpeedButton,
  TypInfo, ComCtrls, ituExceptionDetailsDialog, ituInterfaceFactory, ituVCLUIController,
  utuMessage, utuMessageQueue, XMLIntf, msxmldom, XMLDoc, ituUIController;

type
  TStatus = (StInsert, StDelete, StUpdate, StSelect, StBrowse);

  TPermissao = set of (AcInsert, AcUpdate, AcDelete);

  TitCadastroBasicoV4 = class(itInterfaceForm)
    pnPrincipal: TPanel;
    pnMenuSuperior: TPanel;
    jvGradientSuperior: TJvGradient;
    sbNovo: TJvSpeedButton;
    sbSalvar: TJvSpeedButton;
    sbExcluir: TJvSpeedButton;
    sbSair: TJvSpeedButton;
    shSeparador1: TShape;
    pnDivisor: TPanel;
    sbEditar: TJvSpeedButton;
    procedure sbSairClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure sbEditarClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure sbSalvarClick(Sender: TObject);
    procedure sbExcluirClick(Sender: TObject);
    procedure sbNovoClick(Sender: TObject);
  private
    { Private declarations }
  protected
    hasSearchBeforeNewObject: boolean;
    procedure SetReadOnly(Control: TWinControl; value: Boolean);
    procedure HabilitaEdicao; virtual;
    procedure DesabilitaEdicao; virtual;
    procedure LimpaCampos(Control: TWinControl);
  public
    { Public declarations }
    permissao: TPermissao;
    status: TStatus;
    procedure VerificaPermissoes();
    procedure CadastrarNovoObjeto; virtual;
  end;

  itCadastroBasicoV4 = class(itInterface)
  protected
    procedure SetPermissionsToInteraface(piOperationsNode: utField);
    procedure SendToInterface(piRequest: acRequest);virtual; abstract;
    procedure SaveFromInterface(piRequest: acRequest);virtual; abstract;
    procedure SalvaObjeto(piRequest: acRequest);virtual;
    procedure ExcluirObjeto(piRequest: acRequest);virtual;
    procedure EditaObjeto(piRequest: acRequest);virtual;
    procedure Delete;
    procedure Edita;
  public
    procedure Save;
  end;

implementation
uses acuObject;

{$R *.dfm}

procedure TitCadastroBasicoV4.HabilitaEdicao;
begin
  SetReadOnly(self,false);
end;

procedure TitCadastroBasicoV4.SetReadOnly(Control: TWinControl; value: Boolean);
var
  I: Integer;
begin
  for I := 0 to Control.ControlCount - 1 do
  begin
    if (Control.Controls[i] <> pnMenuSuperior) then
    begin
      try
        if IsPublishedProp(Control.Controls[i],'ReadOnly') then
          SetPropValue(Control.Controls[i],'ReadOnly', value)
        else if //not(control is TPanel)
                not(Control.Controls[i] is TLabel)
                and not(Control.Controls[i] is TPanel)
                and not(Control.Controls[i] is TGroupBox)
                and not(Control.Controls[i] is TPageControl)
                and not(Control.Controls[i] is TTabSheet) then
          Control.Controls[i].Enabled := not value;
      except
        raise;
      end;
      if (Control.Controls[i] is TWinControl)
         and (TWinControl(Control.Controls[i]).ControlCount > 0) then
             SetReadOnly(TWinControl(Control.Controls[i]),value);
    end;
  end;
end;

procedure TitCadastroBasicoV4.DesabilitaEdicao;
begin
  SetReadOnly(self,true);
end;

procedure TitCadastroBasicoV4.LimpaCampos(Control: TWinControl);
var
  I: Integer;
begin
  for I := 0 to Control.ControlCount - 1 do
  begin
    if (Control.Controls[i] <> pnMenuSuperior) then
    begin
      try
        if IsPublishedProp(Control.Controls[i],'Text') then
          SetPropValue(Control.Controls[i],'Text', '');
        if IsPublishedProp(Control.Controls[i],'ItemIndex') then
          SetPropValue(Control.Controls[i],'ItemIndex', -1);
        if IsPublishedProp(Control.Controls[i],'Checked') then
          SetPropValue(Control.Controls[i],'Checked', false)
      except
        raise;
      end;
      if (Control.Controls[i] is TWinControl)
         and (TWinControl(Control.Controls[i]).ControlCount > 0) then
             LimpaCampos(TWinControl(Control.Controls[i]));
    end;
  end;
end;

procedure TitCadastroBasicoV4.VerificaPermissoes();
begin
  if ((status = stInsert) and (AcInsert in permissao))
     or ((status = stUpdate) and (AcUpdate in permissao)) then
  begin
    sbNovo.Enabled := False;
    sbEditar.Enabled := False;
    sbExcluir.Enabled := status = stUpdate;
    sbSalvar.Enabled := True;
    HabilitaEdicao;
  end
  else if (status = stBrowse) then
  begin
    if AcInsert in permissao then
    begin
      sbNovo.Enabled := True;
    end;
    if AcUpdate in permissao then
    begin
      sbEditar.Enabled := True;
    end;
    if AcDelete in permissao then
    begin
      sbExcluir.Enabled := True;
      sbNovo.Enabled := True;
    end;
  end
  else if(status = StDelete)  then
  begin
    sbNovo.Enabled := True;
    sbEditar.Enabled := False;
    sbExcluir.Enabled := False;
    sbSalvar.Enabled := False;
  end
  else
  begin
    sbNovo.Enabled := False;
    sbEditar.Enabled := False;
    sbExcluir.Enabled := False;
    sbSalvar.Enabled := False;
  end;
end;


procedure TitCadastroBasicoV4.sbEditarClick(Sender: TObject);
begin
  inherited;
 (self.Controller as itCadastroBasicoV4).Edita;

end;

procedure TitCadastroBasicoV4.sbExcluirClick(Sender: TObject);
begin
  if MessageDlg('Confirma a excluso do objeto?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
  begin
    (self.Controller as itCadastroBasicoV4).Delete;
    status := stDelete;
    VerificaPermissoes;
  end;
end;

procedure TitCadastroBasicoV4.sbNovoClick(Sender: TObject);
begin
  with (self.Controller as itCadastroBasicoV4)  do
    NewRequest('RM_INCLUI_OBJETO',SendToInterface).Post;
end;

procedure TitCadastroBasicoV4.FormShow(Sender: TObject);
begin
  inherited;
//  if SISAC_Util.GetDisplayColors <= 8 then
  jvGradientSuperior.Visible := false;
  if (status <> stInsert) and (status <> StUpdate) then DesabilitaEdicao
  else HabilitaEdicao;
end;

procedure TitCadastroBasicoV4.CadastrarNovoObjeto;
begin
  status := stInsert;
  VerificaPermissoes;
  LimpaCampos(self);
  HabilitaEdicao;
end;





procedure TitCadastroBasicoV4.FormCreate(Sender: TObject);
begin
  status := StBrowse;
  hasSearchBeforeNewObject := False;
end;

procedure TitCadastroBasicoV4.FormClose(Sender: TObject; var Action: TCloseAction);
const
  NOT_SAVED_MSG = 'Existem dados que ainda no foram salvos.' + #13 +
                  'Deseja realmente sair?';
begin
  if ((status = stInsert) or (status = stUpdate)) and
     (MessageDlg(NOT_SAVED_MSG, mtConfirmation, [mbYes, mbNo], 0) = mrNo)
    then Action := caNone
    else Action := caFree;
end;

procedure TitCadastroBasicoV4.sbSairClick(Sender: TObject);
begin
  Close;
end;

procedure TitCadastroBasicoV4.sbSalvarClick(Sender: TObject);
begin
  (self.Controller as itCadastroBasicoV4).Save;
end;

{ itCadastroBasicoV4 }



procedure itCadastroBasicoV4.Delete;
begin
  self.NewRequest('RM_EXCLUI_OBJETO',ExcluirObjeto).Post;
end;

procedure itCadastroBasicoV4.Edita;
begin
  Screen.Cursor := crHourGlass;
  self.NewRequest('RM_EDITA_OBJETO',EditaObjeto).Post;
end;

procedure itCadastroBasicoV4.EditaObjeto(piRequest: acRequest);
begin
  with self.InterfaceForm as TitCadastroBasicoV4 do
  begin
    status := stUpdate;
    VerificaPermissoes;
    HabilitaEdicao;
  end;
  Screen.Cursor := crDefault;

end;

procedure itCadastroBasicoV4.ExcluirObjeto(piRequest: acRequest);
begin
  ShowMessage('Registro excludo.');
end;

procedure itCadastroBasicoV4.SalvaObjeto(piRequest: acRequest);
begin
  with self.InterfaceForm as TitCadastroBasicoV4 do
  begin
    sbNovo.Enabled := true;
    sbEditar.Enabled := true;
    sbExcluir.Enabled := true;
    sbSalvar.Enabled := false;
    status := StBrowse;
    DesabilitaEdicao;
  end;
end;

procedure itCadastroBasicoV4.Save;
var lMessage: acRequest;
begin
  lMessage := self.NewRequest('RM_SALVA_OBJETO', SalvaObjeto);
  Self.SaveFromInterface(lMessage);
  lMessage.Post;
end;

procedure itCadastroBasicoV4.SetPermissionsToInteraface(
  piOperationsNode: utField);
var lTitCadastroBasico: TitCadastroBasicoV4;
    lOperationNode: utField;
    lCode: integer;
    lmarc : acEnumerator;
begin
  lTitCadastroBasico := self.InterfaceForm as TitCadastroBasicoV4;
  if piOperationsNode.AttributeByName('NewTarget').AsBoolean then
     lTitCadastroBasico.status := StInsert
  else
     lTitCadastroBasico.status := stUpdate;

  lTitCadastroBasico.permissao := [];
  lmarc  := piOperationsNode.GetFieldsEnumerator;
  try
    while not lmarc.EOL  do
    begin
      lOperationNode := utField(lmarc.Current);
      lCode := lOperationNode.AttributeByName('Code').AsInteger;
      case lCode of
        1: lTitCadastroBasico.permissao := lTitCadastroBasico.permissao + [acInsert];
        3: lTitCadastroBasico.permissao := lTitCadastroBasico.permissao + [acUpdate];
        4: lTitCadastroBasico.permissao := lTitCadastroBasico.permissao + [acDelete];
      end;
      lmarc.MoveNext;
    end;
  finally
    lmarc.Free;
  end;
  lTitCadastroBasico.VerificaPermissoes;
end;


end.
