unit acuRegisterModelMappings;


interface

uses
  acuModel, acuRepositorySQL;

const
  ngAnalysis_Name = 0;
  ngAnalysis_Description = 1;
  ngAnalysis_Samples = 2;
  ngAnalysis_Services = 4;
  ngAnalysis_AnalysisType = 3;
  ngAnalysis_RunningSample = 5;
  ngAnalysisType_Name = 0;
  ngAnalysisType_Description = 1;
  ngAnalysisType_EventTypes = 2;
  ngAuditEvent_TransactionId = 0;
  ngAuditEvent_Date = 1;
  ngAuditEvent_UserName = 2;
  ngAuditEvent_EventType = 3;
  ngAuditEvent_UseCaseName = 4;
  ngAuditEvent_ObjectClassName = 5;
  ngAuditEvent_ObjectOID = 6;
  ngAuditEvent_Context = 7;
  ngAuditEvent_Data = 8;
  ngAuditEventData_DataName = 0;
  ngAuditEventData_OldValue = 1;
  ngAuditEventData_NewValue = 2;
  ngAuditEventData_AuditEvent = 3;
  ngAxisX_Code = 0;
  ngAxisX_Description = 1;
  ngAxisX_LevelCount = 2;
  ngAxisX_Divisor = 3;
  ngAxisX_MaiorUltimaFaixa = 4;
  ngAxisX_MenorPrimeiraFaixa = 5;
  ngAxisX_FaixaSistema = 6;
  ngAxisX_Intervals = 7;
  ngBusinessEvent_Data = 0;
  ngBusinessEvent_PublishDateTime = 1;
  ngBusinessEvent_Distributed = 3;
  ngBusinessEvent_EventType = 2;
  ngBusinessEventDistributed_DistributedDateTime = 0;
  ngBusinessEventManager_Name = 0;
  ngBusinessEventManager_LastExec = 1;
  ngBusinessEventSubscriber_code = 0;
  ngBusinessEventSubscriber_Name = 1;
  ngBusinessEventSubscriber_StopOnError = 2;
  ngBusinessEventSubscriber_TimeWindowCheck = 3;
  ngBusinessEventSubscriber_NotifierEventualTimeWindows = 7;
  ngBusinessEventSubscriber_NotifierTimeGrids = 8;
  ngBusinessEventSubscriber_ActiveErrors = 10;
  ngBusinessEventSubscriber_Errors = 6;
  ngBusinessEventSubscriber_EventsType = 4;
  ngBusinessEventSubscriber_IgnoredEvents = 9;
  ngBusinessEventSubscriber_UnnotifiedEvents = 5;
  ngBusinessEventSubscriberError_ErrorDate = 0;
  ngBusinessEventSubscriberError_Description = 1;
  ngBusinessEventSubscriberError_BusinessEvent = 2;
  ngBusinessEventType_Code = 0;
  ngBusinessEventType_Name = 1;
  ngBusinessEventType_Subscribers = 2;
  ngBusinessSubscriberNotifierEventualTimeWindow_ValidAt = 0;
  ngBusinessSubscriberNotifierEventualTimeWindow_StartAt = 1;
  ngBusinessSubscriberNotifierEventualTimeWindow_EndAt = 2;
  ngBusinessSubscriberNotifierEventualTimeWindow_Code = 3;
  ngBusinessSubscriberNotifierEventualTimeWindow_ClosedAt = 4;
  ngBusinessSubscriberNotifierEventualTimeWindow_OpenedAt = 5;
  ngBusinessSubscriberNotifierEventualTimeWindow_Subscriber = 6;
  ngBusinessSubscriberNotifierTimeGrid_ValidFrom = 0;
  ngBusinessSubscriberNotifierTimeGrid_ValidTo = 1;
  ngBusinessSubscriberNotifierTimeGrid_TimeWindows = 3;
  ngBusinessSubscriberNotifierTimeGrid_Subscriber = 2;
  ngBusinessSubscriberNotifierTimeWindow_StartAt = 0;
  ngBusinessSubscriberNotifierTimeWindow_EndAt = 1;
  ngBusinessSubscriberNotifierTimeWindow_Code = 2;
  ngBusinessSubscriberNotifierTimeWindow_OpenedAt = 3;
  ngBusinessSubscriberNotifierTimeWindow_ClosedAt = 4;
  ngBusinessSubscriberNotifierTimeWindow_TimeGrid = 5;
  ngCategory_Name = 0;
  ngCategory_Code = 1;
  ngCategory_Situation = 2;
  ngCategory_UseCases = 3;
  ngEntity_Name = 0;
  ngEntity_Code = 1;
  ngEntity_Caption = 2;
  ngEntity_Situation = 3;
  ngEntity_UseCases = 4;
  ngEvent_DtLaunching = 0;
  ngEvent_EventType = 1;
  ngEvent_User = 2;
  ngEvent_AuthorizedUser = 3;
  ngEventLog_Code = 0;
  ngEventLog_EventType = 1;
  ngEventLog_Source = 2;
  ngEventLog_Description = 3;
  ngEventLog_User = 4;
  ngEventLog_System = 5;
  ngEventLog_DateTime = 6;
  ngEventLog_Session = 7;
  ngEventLog_PeerName = 8;
  ngEventLog_UCInstance = 9;
  ngEventLog_Serial = 10;
  ngEventLog_Statistic = 13;
  ngEventLog_Data = 11;
  ngEventLog_Sample = 12;
  ngEventLogDetail_Detail = 0;
  ngEventLogDetail_EventLog = 1;
  ngEventType_Code = 0;
  ngEventType_ClassTypeName = 1;
  ngEventType_Description = 2;
  ngGUITicket_Name = 0;
  ngGUITicket_Code = 1;
  ngGUITicket_Description = 2;
  ngGUITicket_Situation = 3;
  ngGUITicket_SystemGUIs = 4;
  ngIcon_Description = 0;
  ngIcon_Code = 1;
  ngIcon_Image = 2;
  ngIcon_Situation = 3;
  ngIcon_UseCases = 4;
  ngInterval_Inicio = 0;
  ngInterval_Fim = 1;
  ngInterval_AxisX = 2;
  ngLevel_Code = 0;
  ngLevel_Description = 1;
  ngLevel_Situation = 2;
  ngLevel_System = 4;
  ngLevel_UseCaseOperations = 3;
  ngLogStatistics_Source = 0;
  ngLogStatistics_RequestID = 1;
  ngLogStatistics_StartTime = 2;
  ngLogStatistics_Duration = 3;
  ngLogStatistics_QueueTime = 4;
  ngLogStatistics_CPUTime = 5;
  ngLogStatistics_RequestSize = 6;
  ngLogStatistics_ResponseSize = 7;
  ngLogStatistics_EventLog = 8;
  ngNatureza_Codigo = 0;
  ngNatureza_Descricao = 1;
  ngNatureza_Systems = 2;
  ngOperation_Description = 0;
  ngOperation_Code = 1;
  ngOperation_Situation = 2;
  ngOperation_UseCaseOperations = 3;
  ngPermission_System = 1;
  ngPermission_UseCaseOperation = 0;
  ngPermission_User = 2;
  ngProfile_Code = 0;
  ngProfile_Name = 1;
  ngProfile_Description = 2;
  ngProfile_UseCaseOperations = 3;
  ngProfile_UserProfiles = 4;
  ngResource_ResourceID = 0;
  ngResource_MIMEType = 1;
  ngResource_CreateDatetime = 2;
  ngResource_Data = 3;
  ngSample_StartTime = 0;
  ngSample_EndTime = 1;
  ngSample_EventLogs = 2;
  ngSample_Analysis = 3;
  ngSerialNumber_Number = 0;
  ngSerialNumber_SerialNumberGroup = 1;
  ngSerialNumberGroup_LastUsedNumber = 0;
  ngSerialNumberGroup_InitialNumber = 1;
  ngSerialNumberGroup_Numbers = 2;
  ngService_Caption = 0;
  ngService_Address = 1;
  ngService_Port = 2;
  ngService_SystemCode = 3;
  ngService_UserName = 4;
  ngService_Password = 5;
  ngService_MaxReconnectionAttempts = 6;
  ngService_ReconnectionAttemptDelay = 7;
  ngSystem_Name = 0;
  ngSystem_Description = 1;
  ngSystem_Version = 2;
  ngSystem_Code = 3;
  ngSystem_Situation = 4;
  ngSystem_SystemGUIs = 6;
  ngSystem_Levels = 7;
  ngSystem_SystemUseCases = 9;
  ngSystem_Permissions = 5;
  ngSystem_Events = 8;
  ngSystemConfigUpdateLog_XMLLog = 0;
  ngSystemConfigUpdateLog_UpdateDate = 1;
  ngSystemConfigUpdateLog_UserLogin = 2;
  ngSystemGUITickets_Situation = 0;
  ngSystemGUITickets_GUI = 3;
  ngSystemGUITickets_System = 1;
  ngSystemGUITickets_UseCase = 2;
  ngSystemUseCaseTicket_Situation = 0;
  ngSystemUseCaseTicket_System = 1;
  ngSystemUseCaseTicket_UseCase = 2;
  ngUseCaseTicket_Description = 0;
  ngUseCaseTicket_Name = 1;
  ngUseCaseTicket_Code = 2;
  ngUseCaseTicket_UseCaseType = 3;
  ngUseCaseTicket_Situation = 4;
  ngUseCaseTicket_SystemGUIs = 9;
  ngUseCaseTicket_UseCaseSystems = 10;
  ngUseCaseTicket_UseCaseOperations = 8;
  ngUseCaseTicket_Category = 6;
  ngUseCaseTicket_Entity = 5;
  ngUseCaseTicket_Icon = 7;
  ngUseCaseTicketOperation_Situation = 0;
  ngUseCaseTicketOperation_AccessControlExternalCode = 1;
  ngUseCaseTicketOperation_Events = 6;
  ngUseCaseTicketOperation_Permissions = 2;
  ngUseCaseTicketOperation_Levels = 5;
  ngUseCaseTicketOperation_Operation = 4;
  ngUseCaseTicketOperation_UseCase = 3;
  ngUser_Login = 0;
  ngUser_Password = 1;
  ngUser_PasswordResetCode = 2;
  ngUser_DtRegister = 3;
  ngUser_DtLastChangePassword = 4;
  ngUser_IsCanceled = 5;
  ngUser_CodigoReferencia = 6;
  ngUser_PasswordFormat = 7;
  ngUser_PasswordSalt = 8;
  ngUser_MobilePIN = 9;
  ngUser_Email = 10;
  ngUser_LoweredEmail = 11;
  ngUser_PasswordQuestion = 12;
  ngUser_PasswordAnswer = 13;
  ngUser_IsLockedOut = 14;
  ngUser_LastLoginDate = 15;
  ngUser_LastLockoutDate = 16;
  ngUser_FailedPasswordAttemptCount = 17;
  ngUser_FailedPasswordAttemptWindowStart = 18;
  ngUser_FailedPasswordAnswerAttemptCount = 19;
  ngUser_FailedPasswordAnswerAttemptWindowStart = 20;
  ngUser_Comment = 21;
  ngUser_LastActivityDate = 22;
  ngUser_PermissionSecurityEvents = 23;
  ngUser_Permissions = 25;
  ngUser_SecurityEvents = 26;
  ngUser_Natureza = 24;
  ngUserMessage_Code = 0;
  ngUserMessage_Description = 1;
  ngUserMessage_Name = 2;
  ngUserMessage_Situation = 3;
  ngUserMessage_DetailedDescription = 4;
  ngUserMessage_ShowCode = 5;
  ngUserMessage_DescriptionUser = 6;
  ngUserMessage_System = 7;
  ngUserProfile_Profile = 0;
  ngUserProfile_User = 1;

  procedure RegisterModelMappings(piMetaModelPersistenceMap: acMetaModelPersistenceMapSQL);

implementation

uses
  utuStateMachine, acuUseCaseStateMachine;


procedure RegisterClassTickets1(piMetaModel: acMetaModel; piMetaModelPersistenceMap: acMetaModelPersistenceMapSQL);
var
  lClassMapTicket: acClassTicket;
  lClassToDBMapTicket: acClassToDBMapTicket;
  lDBIntIdoMapTicket: acDBIdoMapTicket;
  prop: acAttributeTicket;
begin
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('972','ngAnalysis','acPersistentObject', 6);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONEIDANAL');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('972', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONETANALY';
  lClassToDBMapTicket.TypeColumnName := 'MONEIDTYPE';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 60;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONENAMEEE';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 200;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONEDESCRI';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('2078','ngAnalysisServerRequests','ngAnalysis', 6);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONEIDANAL');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('2078', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONETANALY';
  lClassToDBMapTicket.TypeColumnName := 'MONEIDTYPE';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('1320','ngAnalysisSystemErrors','ngAnalysis', 6);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONEIDANAL');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('1320', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONETANALY';
  lClassToDBMapTicket.TypeColumnName := 'MONEIDTYPE';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('973','ngAnalysisType','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONFIDANTY');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('973', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONFTANTYP';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 60;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONFNAMEEE';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 200;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONFDESCRI';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('362','ngAuditEvent','acPersistentObject', 9);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SISCIDAUDI');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('362', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SISCTAUDIT';
  prop := lClassMapTicket.NewAttributeTicket('TransactionId', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 38;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCTRANID';
  prop := lClassMapTicket.NewAttributeTicket('Date', 'acDateTime', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCDATETI';
  prop := lClassMapTicket.NewAttributeTicket('UserName', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 30;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCUSERNA';
  prop := lClassMapTicket.NewAttributeTicket('EventType', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 10;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCEVNTYP';
  prop := lClassMapTicket.NewAttributeTicket('UseCaseName', 'acString', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCUCNAME';
  prop := lClassMapTicket.NewAttributeTicket('ObjectClassName', 'acString', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCCLNAME';
  prop := lClassMapTicket.NewAttributeTicket('ObjectOID', 'acString', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 40;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCOBJOID';
  prop := lClassMapTicket.NewAttributeTicket('Context', 'acString', acAttributeStereotype.pvPersistent, False, 7);
  prop.FixSize := 0;
  prop.VarSize := 255;
  prop.Mandatory := False;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISCCONTEX';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('363','ngAuditEventData','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SISDIDEVND');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('363', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SISDTEVNDA';
  prop := lClassMapTicket.NewAttributeTicket('DataName', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISDDATNAM';
  prop := lClassMapTicket.NewAttributeTicket('OldValue', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 4000;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISDOLDVAL';
  prop := lClassMapTicket.NewAttributeTicket('NewValue', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 4000;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISDNEWVAL';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('2275','ngAxisX','acPersistentObject', 8);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONKIDAXIS');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('2275', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONKTAXISX';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKCODEEE';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 200;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKDESCRI';
  prop := lClassMapTicket.NewAttributeTicket('LevelCount', 'acInt', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKLVCOUN';
  prop := lClassMapTicket.NewAttributeTicket('Divisor', 'acInt', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKDIVISO';
  prop := lClassMapTicket.NewAttributeTicket('MaiorUltimaFaixa', 'acInt', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKMAIULT';
  prop := lClassMapTicket.NewAttributeTicket('MenorPrimeiraFaixa', 'acInt', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKMENPRI';
  prop := lClassMapTicket.NewAttributeTicket('FaixaSistema', 'acInt', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONKFAISIT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('278','ngBusinessEvent','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTAIDBUEV');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('278', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTATBUEVN';
  prop := lClassMapTicket.NewAttributeTicket('Data', 'acText', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'TEXT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTADATAAA';
  prop := lClassMapTicket.NewAttributeTicket('PublishDateTime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTAPUBLDT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('744','ngBusinessEventDistributed','acPersistentObject', 1);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTLIDBUED');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('744', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTLTBUEVD';
  prop := lClassMapTicket.NewAttributeTicket('DistributedDateTime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTLDISTDT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('2964','ngBusinessEventManager','acPersistentObject', 2);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTNIMANAG');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('2964', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTNTMANAG';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTNNAME';
  prop := lClassMapTicket.NewAttributeTicket('LastExec', 'acDateTime', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTNEXECDT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('279','ngBusinessEventSubscriber','acPersistentObject', 11);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTBIDSUBS');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('279', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTBTSUBSC';
  prop := lClassMapTicket.NewAttributeTicket('code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTBCODEE';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTBNAMEE';
  prop := lClassMapTicket.NewAttributeTicket('StopOnError', 'acBoolean', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTNSTOPER';
  prop := lClassMapTicket.NewAttributeTicket('TimeWindowCheck', 'acBoolean', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTNWINCHK';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('743','ngBusinessEventSubscriberError','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTJIDSBER');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('743', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTJTSBERR';
  prop := lClassMapTicket.NewAttributeTicket('ErrorDate', 'acDateTime', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTJDTERRO';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acText', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 512;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTJDESCRI';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('280','ngBusinessEventType','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTCIDEVNT');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('280', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTCTEVNTP';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTCCODEEE';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTCNAMEEE';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('742','ngBusinessSubscriberNotifierEventualTimeWindow','acPersistentObject', 7);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTHIDETMW');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('742', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTHTETMWI';
  prop := lClassMapTicket.NewAttributeTicket('ValidAt', 'acDateTime', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTHVDATTT';
  prop := lClassMapTicket.NewAttributeTicket('StartAt', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTHSTARTA';
  prop := lClassMapTicket.NewAttributeTicket('EndAt', 'acInt', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTHENDATT';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTHCODEEE';
  prop := lClassMapTicket.NewAttributeTicket('ClosedAt', 'acInt', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTHCLOSAT';
  prop := lClassMapTicket.NewAttributeTicket('OpenedAt', 'acInt', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTHOPENAT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('740','ngBusinessSubscriberNotifierTimeGrid','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTFIDTMGR');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('740', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTFTTMGRD';
  prop := lClassMapTicket.NewAttributeTicket('ValidFrom', 'acDateTime', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTFVDFROM';
  prop := lClassMapTicket.NewAttributeTicket('ValidTo', 'acDateTime', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'DATETIME';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTFVDTOOO';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('741','ngBusinessSubscriberNotifierTimeWindow','acPersistentObject', 6);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('INTGIDTMWI');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('741', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'INTGTTMWIN';
  prop := lClassMapTicket.NewAttributeTicket('StartAt', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTGSTARTA';
  prop := lClassMapTicket.NewAttributeTicket('EndAt', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTGENDATT';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTGCODEEE';
  prop := lClassMapTicket.NewAttributeTicket('OpenedAt', 'acInt', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTGOPENAT';
  prop := lClassMapTicket.NewAttributeTicket('ClosedAt', 'acInt', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 4;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'INT';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'INTGCLOSAT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-3','ngCategory','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESDIDCATE');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-3', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESDTCATEG';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESDNMCATE';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESDCDCATE';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESDCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-4','ngEntity','acPersistentObject', 5);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESCIDENTI');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-4', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESCTENTID';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESCNMENTI';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESCCDENTI';
  prop := lClassMapTicket.NewAttributeTicket('Caption', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESCTIENTI';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESCCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-8','ngEvent','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SEGCIDESEG');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-8', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SEGCTEVSEG';
  prop := lClassMapTicket.NewAttributeTicket('DtLaunching', 'acDateTime', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGCDTLANC';
  prop := lClassMapTicket.NewAttributeTicket('EventType', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'char';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGCTPEVEN';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('963','ngEventLog','acPersistentObject', 14);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONBIDEVLO');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('963', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONBTEVLOG';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBCODEEE';
  prop := lClassMapTicket.NewAttributeTicket('EventType', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 60;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBEVTYPE';
  prop := lClassMapTicket.NewAttributeTicket('Source', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 60;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBSOURCE';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 200;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBDESCRI';
  prop := lClassMapTicket.NewAttributeTicket('User', 'acString', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 0;
  prop.VarSize := 40;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBUSERRR';
  prop := lClassMapTicket.NewAttributeTicket('System', 'acString', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 0;
  prop.VarSize := 30;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBSYSTEM';
  prop := lClassMapTicket.NewAttributeTicket('DateTime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBDTTIME';
  prop := lClassMapTicket.NewAttributeTicket('Session', 'acString', acAttributeStereotype.pvPersistent, False, 7);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBSESSION';
  prop := lClassMapTicket.NewAttributeTicket('PeerName', 'acString', acAttributeStereotype.pvPersistent, False, 8);
  prop.FixSize := 0;
  prop.VarSize := 30;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBPEERNA';
  prop := lClassMapTicket.NewAttributeTicket('UCInstance', 'acString', acAttributeStereotype.pvPersistent, False, 9);
  prop.FixSize := 0;
  prop.VarSize := 120;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBUCINST';
  prop := lClassMapTicket.NewAttributeTicket('Serial', 'acInt', acAttributeStereotype.pvPersistent, False, 10);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBSERIAL';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('964','ngEventLogDetail','acPersistentObject', 2);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONCIDEVLD');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('964', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONCTEVLDT';
  prop := lClassMapTicket.NewAttributeTicket('Detail', 'acText', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 32000;
  prop.Mandatory := True;
  prop.DBType := 'text';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONCLOGDET';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('974','ngEventType','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONGIDEVTP');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('974', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONGTEVTYP';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONGCODEEE';
  prop := lClassMapTicket.NewAttributeTicket('ClassTypeName', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 60;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONGCLASSS';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 200;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONGDESCRI';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('128','ngGUITicket','acPersistentObject', 5);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESOIDINTE');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('128', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESOTINTER';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESONMINTE';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESOCDINTE';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 250;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESODSINTE';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESOCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-2','ngIcon','acPersistentObject', 5);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESFIDCUIC');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-2', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESFTCUICO';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESFDSCUIC';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESFCDCUIC';
  prop := lClassMapTicket.NewAttributeTicket('Image', 'acBlob', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 16;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'image';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESFIMCUIC';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESFCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('2276','ngInterval','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONJIDINTE');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('2276', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONJTINTER';
  prop := lClassMapTicket.NewAttributeTicket('Inicio', 'acDouble', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 10;
  prop.VarSize := 2;
  prop.Mandatory := True;
  prop.DBType := 'Decimal';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONBFXINIC';
  prop := lClassMapTicket.NewAttributeTicket('Fim', 'acDouble', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 10;
  prop.VarSize := 2;
  prop.Mandatory := True;
  prop.DBType := 'Decimal';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONJFXFIMM';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-11','ngLevel','acPersistentObject', 5);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESHIDLEVE');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-11', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESHTLEVEL';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESHCDLEVE';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESHDSLEVE';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESHCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('2772','ngLogStatistics','acPersistentObject', 9);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONLIDSTAT');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('2772', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONLTSTATI';
  prop := lClassMapTicket.NewAttributeTicket('Source', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 255;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLSOURCE';
  prop := lClassMapTicket.NewAttributeTicket('RequestID', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 255;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLRQSTID';
  prop := lClassMapTicket.NewAttributeTicket('StartTime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLSTTIME';
  prop := lClassMapTicket.NewAttributeTicket('Duration', 'acInt', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLDUTIME';
  prop := lClassMapTicket.NewAttributeTicket('QueueTime', 'acInt', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLQUTIME';
  prop := lClassMapTicket.NewAttributeTicket('CPUTime', 'acInt', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLCPTIME';
  prop := lClassMapTicket.NewAttributeTicket('RequestSize', 'acInt', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLRQSIZE';
  prop := lClassMapTicket.NewAttributeTicket('ResponseSize', 'acInt', acAttributeStereotype.pvPersistent, False, 7);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONLRSSIZE';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('132','ngNatureza','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SEGDIDNAUS');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('132', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SEGDTNAUSU';
  prop := lClassMapTicket.NewAttributeTicket('Codigo', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGDCDNAUS';
  prop := lClassMapTicket.NewAttributeTicket('Descricao', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGDDSNAUS';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-9','ngOperation','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESJIDOPER');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-9', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESJTOPERA';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESJDSOPER';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESJCDOPER';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESJCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-7','ngPermission','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SEGBIDPERM');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-7', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SEGBTPERMI';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('1518','ngProfile','acPersistentObject', 5);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESSIDPROF');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('1518', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESSTPROFI';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESSCDPROF';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 40;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESSNMPROF';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESSDSPROF';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('2952','ngResource','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESVIDRESR');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('2952', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESVTRESRC';
  prop := lClassMapTicket.NewAttributeTicket('ResourceID', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESVRESRID';
  prop := lClassMapTicket.NewAttributeTicket('MIMEType', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESVMIMETP';
  prop := lClassMapTicket.NewAttributeTicket('CreateDatetime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESVCREADT';
  prop := lClassMapTicket.NewAttributeTicket('Data', 'acBlob', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'IMAGE';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESVRESRCE';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('971','ngSample','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONDIDSAMP');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('971', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONDTSAMPL';
  prop := lClassMapTicket.NewAttributeTicket('StartTime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONDSTTIME';
  prop := lClassMapTicket.NewAttributeTicket('EndTime', 'acDateTime', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONDENTIME';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('838','ngSerialNumber','acPersistentObject', 2);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SISGIDSERN');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('838', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SISGSERNUM';
  prop := lClassMapTicket.NewAttributeTicket('Number', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'Int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISGSERNUM';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('839','ngSerialNumberGroup','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SISFIDSERG');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('839', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SISFSERGRP';
  prop := lClassMapTicket.NewAttributeTicket('LastUsedNumber', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'Int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISFLSTNUM';
  prop := lClassMapTicket.NewAttributeTicket('InitialNumber', 'acInt', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'Int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SISFININUM';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('269','ngService','acPersistentObject', 8);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('MONAIDSERV');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('269', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'MONATSERVE';
  prop := lClassMapTicket.NewAttributeTicket('Caption', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONACAPTIO';
  prop := lClassMapTicket.NewAttributeTicket('Address', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONAADDRES';
  prop := lClassMapTicket.NewAttributeTicket('Port', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 30;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONASERVIC';
  prop := lClassMapTicket.NewAttributeTicket('SystemCode', 'acInt', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONASYSCOD';
  prop := lClassMapTicket.NewAttributeTicket('UserName', 'acString', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 0;
  prop.VarSize := 40;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONAUSRNAM';
  prop := lClassMapTicket.NewAttributeTicket('Password', 'acString', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONAPASSWO';
  prop := lClassMapTicket.NewAttributeTicket('MaxReconnectionAttempts', 'acInt', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONAMAXATT';
  prop := lClassMapTicket.NewAttributeTicket('ReconnectionAttemptDelay', 'acInt', acAttributeStereotype.pvPersistent, False, 7);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'MONAATTDEL';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-5','ngSystem','acPersistentObject', 10);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESAIDSIST');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-5', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESATSISTE';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 10;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESANMSIST';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESADSSIST';
  prop := lClassMapTicket.NewAttributeTicket('Version', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 10;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESAVERSAO';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESACDSIST';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESACDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-12','ngSystemConfigUpdateLog','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESQIDUPLO');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-12', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESQTUPLOG';
  prop := lClassMapTicket.NewAttributeTicket('XMLLog', 'acText', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 9999999;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'Text';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESQXMLOG';
  prop := lClassMapTicket.NewAttributeTicket('UpdateDate', 'acDateTime', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESQUDATE';
  prop := lClassMapTicket.NewAttributeTicket('UserLogin', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := True;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESQCDLOGI';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('129','ngSystemGUITickets','acPersistentObject', 4);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESPIDSISI');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('129', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESPTSISIN';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESPCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-14','ngSystemUseCaseTicket','acPersistentObject', 3);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESEIDSISC');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-14', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESETSISCU';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESECDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-1','ngUseCaseTicket','acPersistentObject', 11);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESBIDCASO');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-1', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESBTCASOU';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 250;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESBDSCASO';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 50;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESBNMCASO';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESBCDCASO';
  prop := lClassMapTicket.NewAttributeTicket('UseCaseType', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'char';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESBTPCASO';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESBCDSITU';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-10','ngUseCaseTicketOperation','acPersistentObject', 7);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESGIDCUOP');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-10', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESGTCUOPE';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESGCDSITU';
  prop := lClassMapTicket.NewAttributeTicket('AccessControlExternalCode', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'VARCHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESGCDACEX';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('-6','ngUser','acPersistentObject', 27);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('SEGAIDUSUA');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('-6', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'SEGATUSUAR';
  lClassToDBMapTicket.TypeColumnName := 'SEGACDHERA';
  prop := lClassMapTicket.NewAttributeTicket('Login', 'acString', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 25;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGACDUSUA';
  prop := lClassMapTicket.NewAttributeTicket('Password', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 256;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGASENHAU';
  prop := lClassMapTicket.NewAttributeTicket('PasswordResetCode', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 20;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAPRSETC';
  prop := lClassMapTicket.NewAttributeTicket('DtRegister', 'acDateTime', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGADTCADU';
  prop := lClassMapTicket.NewAttributeTicket('DtLastChangePassword', 'acDateTime', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGADTULSE';
  prop := lClassMapTicket.NewAttributeTicket('IsCanceled', 'acBoolean', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAINCANC';
  prop := lClassMapTicket.NewAttributeTicket('CodigoReferencia', 'acString', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 25;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGACDREFE';
  prop := lClassMapTicket.NewAttributeTicket('PasswordFormat', 'acInt', acAttributeStereotype.pvPersistent, False, 7);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAFORMSE';
  prop := lClassMapTicket.NewAttributeTicket('PasswordSalt', 'acString', acAttributeStereotype.pvPersistent, False, 8);
  prop.FixSize := 0;
  prop.VarSize := 128;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGASALTSE';
  prop := lClassMapTicket.NewAttributeTicket('MobilePIN', 'acString', acAttributeStereotype.pvPersistent, False, 9);
  prop.FixSize := 0;
  prop.VarSize := 16;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAMOBILE';
  prop := lClassMapTicket.NewAttributeTicket('Email', 'acString', acAttributeStereotype.pvPersistent, False, 10);
  prop.FixSize := 0;
  prop.VarSize := 256;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAEEMAIL';
  prop := lClassMapTicket.NewAttributeTicket('LoweredEmail', 'acString', acAttributeStereotype.pvPersistent, False, 11);
  prop.FixSize := 0;
  prop.VarSize := 256;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGALEMAIL';
  prop := lClassMapTicket.NewAttributeTicket('PasswordQuestion', 'acString', acAttributeStereotype.pvPersistent, False, 12);
  prop.FixSize := 0;
  prop.VarSize := 256;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGASENHAQ';
  prop := lClassMapTicket.NewAttributeTicket('PasswordAnswer', 'acString', acAttributeStereotype.pvPersistent, False, 13);
  prop.FixSize := 0;
  prop.VarSize := 256;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGASENHAA';
  prop := lClassMapTicket.NewAttributeTicket('IsLockedOut', 'acBoolean', acAttributeStereotype.pvPersistent, False, 14);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGABLOQUE';
  prop := lClassMapTicket.NewAttributeTicket('LastLoginDate', 'acDateTime', acAttributeStereotype.pvPersistent, False, 15);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAULTLGN';
  prop := lClassMapTicket.NewAttributeTicket('LastLockoutDate', 'acDateTime', acAttributeStereotype.pvPersistent, False, 16);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAULTBLQ';
  prop := lClassMapTicket.NewAttributeTicket('FailedPasswordAttemptCount', 'acInt', acAttributeStereotype.pvPersistent, False, 17);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAFSACOU';
  prop := lClassMapTicket.NewAttributeTicket('FailedPasswordAttemptWindowStart', 'acDateTime', acAttributeStereotype.pvPersistent, False, 18);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAFSAWST';
  prop := lClassMapTicket.NewAttributeTicket('FailedPasswordAnswerAttemptCount', 'acInt', acAttributeStereotype.pvPersistent, False, 19);
  prop.FixSize := 10;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAFSAACO';
  prop := lClassMapTicket.NewAttributeTicket('FailedPasswordAnswerAttemptWindowStart', 'acDateTime', acAttributeStereotype.pvPersistent, False, 20);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAFSAAWS';
  prop := lClassMapTicket.NewAttributeTicket('Comment', 'acString', acAttributeStereotype.pvPersistent, False, 21);
  prop.FixSize := 16;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'text';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGACOMMEN';
  prop := lClassMapTicket.NewAttributeTicket('LastActivityDate', 'acDateTime', acAttributeStereotype.pvPersistent, False, 22);
  prop.FixSize := 8;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'datetime';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'SEGAULTACT';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('515','ngUserMessage','acPersistentObject', 8);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESRIDMESS');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('515', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESRTMESSG';
  prop := lClassMapTicket.NewAttributeTicket('Code', 'acInt', acAttributeStereotype.pvPersistent, False, 0);
  prop.FixSize := 0;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'int';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRCDMESS';
  prop := lClassMapTicket.NewAttributeTicket('Description', 'acString', acAttributeStereotype.pvPersistent, False, 1);
  prop.FixSize := 0;
  prop.VarSize := 300;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRDSMESS';
  prop := lClassMapTicket.NewAttributeTicket('Name', 'acString', acAttributeStereotype.pvPersistent, False, 2);
  prop.FixSize := 0;
  prop.VarSize := 100;
  prop.Mandatory := True;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRSGMESS';
  prop := lClassMapTicket.NewAttributeTicket('Situation', 'acString', acAttributeStereotype.pvPersistent, False, 3);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := True;
  prop.DBType := 'CHAR';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRCDSITU';
  prop := lClassMapTicket.NewAttributeTicket('DetailedDescription', 'acString', acAttributeStereotype.pvPersistent, False, 4);
  prop.FixSize := 0;
  prop.VarSize := 4000;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRDSDETA';
  prop := lClassMapTicket.NewAttributeTicket('ShowCode', 'acString', acAttributeStereotype.pvPersistent, False, 5);
  prop.FixSize := 1;
  prop.VarSize := 0;
  prop.Mandatory := False;
  prop.DBType := 'char';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRSHOCOD';
  prop := lClassMapTicket.NewAttributeTicket('DescriptionUser', 'acString', acAttributeStereotype.pvPersistent, False, 6);
  prop.FixSize := 0;
  prop.VarSize := 300;
  prop.Mandatory := False;
  prop.DBType := 'varchar';
  lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := 'IESRDSMEUS';
  
  lClassMapTicket    := piMetaModel.NewClassRegisterTicket('1540','ngUserProfile','acPersistentObject', 2);
  lClassMapTicket.AuditDescription := '';
  
  lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create('IESUIDUSEP');
  lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('1540', lClassMapTicket, lDBIntIdoMapTicket) ;
  lClassToDBMapTicket.TableName := 'IESUTUSERP';
end;

procedure RegisterClassRelationTickets1(piMetaModel: acMetaModel; piMetaModelPersistenceMap: acMetaModelPersistenceMapSQL);
var
  lRelationTicket: acRelationTicket;
begin
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngAnalysis', 'Samples', 2, 0, 2147483647, acPropertyAggregation.pvNone, 'Analysis has samples', 'ngSample', 'Analysis', 3, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'MONEIDANAL');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngAnalysis', 'Services', 4, 0, 2147483647, acPropertyAggregation.pvNone, 'Analysis listen to Servers', 'ngService', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'MONEIDANAL', 'MONAIDSERV', 'MONITANSRV');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngAnalysisType', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, 'Analysis has a type', 'ngAnalysis', 'AnalysisType', 3, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'MONFIDANTY');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngAnalysisType', 'EventTypes', 2, 1, 2147483647, acPropertyAggregation.pvNone, 'AnalysisType has EventTypes', 'ngEventType', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'MONFIDANTY', 'MONGIDEVTP', 'MONHTEVANA');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngAuditEvent', 'Data', 8, 0, 2147483647, acPropertyAggregation.pvNone, 'Audit Event has Data', 'ngAuditEventData', 'AuditEvent', 3, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SISDIDAUDI');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngAxisX', 'Intervals', 7, 0, 2147483647, acPropertyAggregation.pvNone, '', 'ngInterval', 'AxisX', 2, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'MONJIDAXIS');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEvent', 'Distributed', 3, 0, 1, acPropertyAggregation.pvComposite, 'Distributed BusinessEvent', 'ngBusinessEventDistributed', '', -1, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToOneDbRelationMapRegisterTicket(lRelationTicket, 'INTLIDBUEV');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEvent', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, 'SubscriberError has Event', 'ngBusinessEventSubscriberError', 'BusinessEvent', 2, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTJIDBUEV');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'NotifierEventualTimeWindows', 7, 0, 2147483647, acPropertyAggregation.pvComposite, 'Subscriber has eventual notifier time windows', 'ngBusinessSubscriberNotifierEventualTimeWindow', 'Subscriber', 6, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTHIDSUBS');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'NotifierTimeGrids', 8, 0, 2147483647, acPropertyAggregation.pvComposite, 'Subscriber has notifier time grids', 'ngBusinessSubscriberNotifierTimeGrid', 'Subscriber', 2, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTFIDSUBS');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'ActiveErrors', 10, 0, 2147483647, acPropertyAggregation.pvNone, 'Subscriber''s Active Errors', 'ngBusinessEventSubscriberError', '', -1, 0, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewIndirectOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTBIDSUBS', 'INTJIDSBER', 'INTKTSUBER');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'Errors', 6, 0, 2147483647, acPropertyAggregation.pvComposite, 'Subscriber''s Errors', 'ngBusinessEventSubscriberError', '', -1, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTJIDSUBS');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'EventsType', 4, 0, 2147483647, acPropertyAggregation.pvNone, 'Subscriber''s Events Type of Interest', 'ngBusinessEventType', 'Subscribers', 2, 0, 2147483647, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTBIDSUBS', 'INTCIDEVNT', 'INTETINTER');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'IgnoredEvents', 9, 0, 2147483647, acPropertyAggregation.pvNone, 'Subscriber''s Ignored Events', 'ngBusinessEvent', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTBIDSUBS', 'INTAIDBUEV', 'INTITIGNOR');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventSubscriber', 'UnnotifiedEvents', 5, 0, 2147483647, acPropertyAggregation.pvNone, 'Subscriber''s Unnotified Events', 'ngBusinessEvent', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTBIDSUBS', 'INTAIDBUEV', 'INTDTUNNOT');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessEventType', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, 'Event has type', 'ngBusinessEvent', 'EventType', 2, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTAIDEVNT');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngBusinessSubscriberNotifierTimeGrid', 'TimeWindows', 3, 0, 2147483647, acPropertyAggregation.pvComposite, 'Time grid has time windows', 'ngBusinessSubscriberNotifierTimeWindow', 'TimeGrid', 5, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'INTGIDTMGR');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngCategory', 'UseCases', 3, 0, 2147483647, acPropertyAggregation.pvNone, 'Usecases have a category', 'ngUseCaseTicket', 'Category', 6, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESBIDCATE');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngEntity', 'UseCases', 4, 0, 2147483647, acPropertyAggregation.pvNone, 'Entity has Usecases', 'ngUseCaseTicket', 'Entity', 5, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESBIDENTI');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngEventLog', 'Statistic', 13, 0, 1, acPropertyAggregation.pvNone, '', 'ngLogStatistics', 'EventLog', 8, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToOneDbRelationMapRegisterTicket(lRelationTicket, 'MONLIDEVLO');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngEventLog', 'Data', 11, 0, 1, acPropertyAggregation.pvNone, 'EventLog has Data', 'ngEventLogDetail', 'EventLog', 1, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToOneDbRelationMapRegisterTicket(lRelationTicket, 'MONBIDEVLO');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngGUITicket', 'SystemGUIs', 4, 0, 2147483647, acPropertyAggregation.pvNone, 'System GUIs have GUI', 'ngSystemGUITickets', 'GUI', 3, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESPIDINTE');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngIcon', 'UseCases', 4, 0, 2147483647, acPropertyAggregation.pvNone, 'Usecases have an icon', 'ngUseCaseTicket', 'Icon', 7, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESBIDCUIC');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngNatureza', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, 'User has nature', 'ngUser', 'Natureza', 24, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGAIDNAUS');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngNatureza', 'Systems', 2, 0, 2147483647, acPropertyAggregation.pvNone, 'User nature can access systems', 'ngSystem', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGEIDNAUS', 'SEGEIDSIST', 'SEGETSINAU');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngOperation', 'UseCaseOperations', 3, 0, 2147483647, acPropertyAggregation.pvNone, 'UseCase operations has operation', 'ngUseCaseTicketOperation', 'Operation', 4, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESGIDOPER');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngProfile', 'UseCaseOperations', 3, 0, 2147483647, acPropertyAggregation.pvNone, 'Profile has Usecase Operations', 'ngUseCaseTicketOperation', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESSIDPROF', 'IESGIDCUOP', 'IESTTOPPRO');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngProfile', 'UserProfiles', 4, 0, 2147483647, acPropertyAggregation.pvNone, 'Profile has Users', 'ngUserProfile', 'Profile', 0, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESUIDPROF');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSample', '', -1, 1, 1, acPropertyAggregation.pvNone, 'Analysis has running sample', 'ngAnalysis', 'RunningSample', 5, 0, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToOneDbRelationMapRegisterTicket(lRelationTicket, 'MONDIDSAMP');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSample', 'EventLogs', 2, 0, 2147483647, acPropertyAggregation.pvNone, 'Sample has EventLogs', 'ngEventLog', 'Sample', 12, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'MONDIDSAMP');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSerialNumberGroup', 'Numbers', 2, 0, 2147483647, acPropertyAggregation.pvComposite, 'SerialNumberGroup has serial numbers', 'ngSerialNumber', 'SerialNumberGroup', 1, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SISGIDSGRP');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSystem', 'SystemGUIs', 6, 0, 2147483647, acPropertyAggregation.pvNone, 'System has GUIs', 'ngSystemGUITickets', 'System', 1, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESPIDSIST');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSystem', 'Levels', 7, 0, 2147483647, acPropertyAggregation.pvNone, 'System has Levels', 'ngLevel', 'System', 4, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESHIDSIST');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSystem', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, 'System has Message', 'ngUserMessage', 'System', 7, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESRIDSIST');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSystem', 'SystemUseCases', 9, 0, 2147483647, acPropertyAggregation.pvNone, 'System has Usecases', 'ngSystemUseCaseTicket', 'System', 1, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESEIDSIST');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSystem', 'Permissions', 5, 0, 2147483647, acPropertyAggregation.pvNone, 'System has permissions', 'ngPermission', 'System', 1, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGBIDSIST');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngSystem', 'Events', 8, 0, 2147483647, acPropertyAggregation.pvNone, 'System has security events', 'ngEvent', '', -1, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGCIDSIST');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUseCaseTicket', 'SystemGUIs', 9, 0, 2147483647, acPropertyAggregation.pvNone, 'UseCase has system GUIs', 'ngSystemGUITickets', 'UseCase', 2, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESPIDCASO');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUseCaseTicket', 'UseCaseSystems', 10, 0, 2147483647, acPropertyAggregation.pvNone, 'Usecas has systems', 'ngSystemUseCaseTicket', 'UseCase', 2, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESEIDCASO');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUseCaseTicket', 'UseCaseOperations', 8, 0, 2147483647, acPropertyAggregation.pvNone, 'Usecase has usecase operations', 'ngUseCaseTicketOperation', 'UseCase', 3, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESGIDCASO');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUseCaseTicketOperation', 'Events', 6, 0, 2147483647, acPropertyAggregation.pvNone, 'Use Case Operations have security events', 'ngEvent', '', -1, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGCIDCUOP');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUseCaseTicketOperation', 'Permissions', 2, 0, 2147483647, acPropertyAggregation.pvNone, 'UseCase Operation has permissions', 'ngPermission', 'UseCaseOperation', 0, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGBIDCUOP');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUseCaseTicketOperation', 'Levels', 5, 0, 2147483647, acPropertyAggregation.pvNone, 'Usecase Operations has levels', 'ngLevel', 'UseCaseOperations', 3, 0, 2147483647, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESIIDCUOP', 'IESIIDLEVE', 'IESITOPLEV');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUser', 'PermissionSecurityEvents', 23, 0, 2147483647, acPropertyAggregation.pvNone, 'User generate security events', 'ngEvent', 'User', 2, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGCIDUSUA');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUser', 'Permissions', 25, 0, 2147483647, acPropertyAggregation.pvNone, 'User has Permissions', 'ngPermission', 'User', 2, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGBIDUSUA');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUser', '', -1, 0, 2147483647, acPropertyAggregation.pvNone, 'User has Profiles', 'ngUserProfile', 'User', 1, 1, 1, acPropertyAggregation.pvNone, False, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'IESUIDUSUA');
  
  lRelationTicket := piMetaModel.NewRelationRegisterTicket('ngUser', 'SecurityEvents', 26, 0, 2147483647, acPropertyAggregation.pvNone, 'User has security events', 'ngEvent', 'AuthorizedUser', 3, 1, 1, acPropertyAggregation.pvNone, True, False);
  if lRelationTicket <> nil then piMetaModelPersistenceMap.NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, 'SEGCIDRESP');
  
end;

procedure NewUseCaseTicket_ucImportaConfiguracaoSistema_1327(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1327', nil, True);
  lUseCaseTicket.Name := 'ucImportaConfiguracaoSistema';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucCadastroNatureza_1360(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1360', nil, True);
  lUseCaseTicket.Name := 'ucCadastroNatureza';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucDetalhesAtualizacaoSistema_1359(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1359', nil, True);
  lUseCaseTicket.Name := 'ucDetalhesAtualizacaoSistema';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucControleAcesso_104(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('104', nil, True);
  lUseCaseTicket.Name := 'ucControleAcesso';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucExplorerV4_1432(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1432', nil, True);
  lUseCaseTicket.Name := 'ucExplorerV4';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucCadastroPerfil_1963(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1963', nil, False);
  lUseCaseTicket.Name := 'ucCadastroPerfil';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucCadastroUsuarioSistema_101(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('101', nil, True);
  lUseCaseTicket.Name := 'ucCadastroUsuarioSistema';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucPropriedadesDoServico_1536(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1536', nil, True);
  lUseCaseTicket.Name := 'ucPropriedadesDoServico';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucCadastroServidores_1153(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1153', nil, True);
  lUseCaseTicket.Name := 'ucCadastroServidores';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucSISMONEventLogServer_1603(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1603', nil, True);
  lUseCaseTicket.Name := 'ucSISMONEventLogServer';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucEventLogAnalyser_1611(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('1611', nil, True);
  lUseCaseTicket.Name := 'ucEventLogAnalyser';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucEventLogAnaliserGraphic_2603(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('2603', nil, True);
  lUseCaseTicket.Name := 'ucEventLogAnaliserGraphic';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucCadastroAxisX_2605(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('2605', nil, True);
  lUseCaseTicket.Name := 'ucCadastroAxisX';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

procedure NewUseCaseTicket_ucDashBoard_2930(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
begin
  lUseCaseTicket := piMetaModel.NewUseCaseTicket('2930', nil, True);
  lUseCaseTicket.Name := 'ucDashBoard';
  lUseCaseTicket.InheritsFromClass := 'ucUseCase';
end;

function GetXSDIn_1153_smCadastroServidores_stAguardando_RM_INCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stAguardando_RM_INCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence minOccurs="1" maxOccurs="1">' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="optional">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="optional">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="optional">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="optional"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stAguardando_RM_EXCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stAguardando_RM_EDITA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stAguardando_RM_EDITA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stAguardando_RM_CONSULTA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stAguardando_RM_CONSULTA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stEditando_RM_SALVA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stEditando_RM_SALVA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stEditando_RM_EXCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stEditando_RM_VALIDA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stEditando_RM_VALIDA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stConsultando_RM_INCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stConsultando_RM_INCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence minOccurs="1" maxOccurs="1">' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="optional">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="optional">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="optional">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="optional"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stConsultando_RM_EDITA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stConsultando_RM_EDITA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stConsultando_RM_EXCLUI_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1153_smCadastroServidores_stConsultando_RM_CONSULTA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="OBJECTID" type="xs:string"/>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1153_smCadastroServidores_stConsultando_RM_CONSULTA_OBJETO: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element name="Server">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:integer" use="required"/>' + #13#10 +
  '								<xs:attribute name="Caption" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Address" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="100"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="Service" use="required">' + #13#10 +
  '									<xs:simpleType>' + #13#10 +
  '										<xs:restriction base="xs:string">' + #13#10 +
  '											<xs:maxLength value="30"/>' + #13#10 +
  '										</xs:restriction>' + #13#10 +
  '									</xs:simpleType>' + #13#10 +
  '								</xs:attribute>' + #13#10 +
  '								<xs:attribute name="UserName" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Password" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="SystemCode" type="xs:int" use="required"/>' + #13#10 +
  '								<xs:attribute name="MaxReconnectionAttempts" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="ReconnectionAttemptDelay" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Initializing_RM_GET_CONTEXT: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Initializing_RM_GET_CONTEXT: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:all>' + #13#10 +
  '				<xs:element name="ServersList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:simpleContent>' + #13#10 +
  '										<xs:extension base="xs:string">' + #13#10 +
  '											<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '										</xs:extension>' + #13#10 +
  '									</xs:simpleContent>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '				<xs:element name="AnalysisList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence minOccurs="0" maxOccurs="unbounded">' + #13#10 +
  '							<xs:element name="Analysis">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:sequence minOccurs="0" maxOccurs="unbounded">' + #13#10 +
  '										<xs:element name="Sample">' + #13#10 +
  '											<xs:complexType>' + #13#10 +
  '												<xs:sequence minOccurs="0" maxOccurs="unbounded">' + #13#10 +
  '													<xs:element name="Event">' + #13#10 +
  '														<xs:complexType>' + #13#10 +
  '															<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="Timestamp" type="xs:dateTime" use="required"/>' + #13#10 +
  '															<xs:attribute name="Source" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="PeerName" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="Type" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="Description" type="xs:string" use="required"/>' + #13#10 +
  '														</xs:complexType>' + #13#10 +
  '													</xs:element>' + #13#10 +
  '												</xs:sequence>' + #13#10 +
  '												<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '												<xs:attribute name="StartTime" type="xs:dateTime" use="required"/>' + #13#10 +
  '												<xs:attribute name="EndTime" type="xs:dateTime" use="optional"/>' + #13#10 +
  '												<xs:attribute name="Running" type="xs:boolean" use="required"/>' + #13#10 +
  '											</xs:complexType>' + #13#10 +
  '										</xs:element>' + #13#10 +
  '									</xs:sequence>' + #13#10 +
  '									<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="Name" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="Description" type="xs:string" use="optional"/>' + #13#10 +
  '									<xs:attribute name="AnalysisType" type="xs:string" use="required"/>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '						<xs:attribute name="SampleCount" type="xs:string" use="required"/>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:all>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Executing_RM_NEW_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Executing_RM_NEW_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:all>' + #13#10 +
  '				<xs:element name="AnalysisTypeList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="AnalysisType">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:simpleContent>' + #13#10 +
  '										<xs:extension base="xs:string">' + #13#10 +
  '											<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Description" type="xs:string"/>' + #13#10 +
  '										</xs:extension>' + #13#10 +
  '									</xs:simpleContent>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '				<xs:element name="ServerList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:simpleContent>' + #13#10 +
  '										<xs:extension base="xs:string">' + #13#10 +
  '											<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '										</xs:extension>' + #13#10 +
  '									</xs:simpleContent>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '				<xs:element minOccurs="0" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence minOccurs="1" maxOccurs="1">' + #13#10 +
  '							<xs:element minOccurs="1" maxOccurs="1" name="Servers">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:sequence>' + #13#10 +
  '										<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '											<xs:complexType>' + #13#10 +
  '												<xs:simpleContent>' + #13#10 +
  '													<xs:extension base="xs:string">' + #13#10 +
  '														<xs:attribute name="OID" use="required"/>' + #13#10 +
  '													</xs:extension>' + #13#10 +
  '												</xs:simpleContent>' + #13#10 +
  '											</xs:complexType>' + #13#10 +
  '										</xs:element>' + #13#10 +
  '									</xs:sequence>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '						<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '						<xs:attribute name="Description" type="xs:string"/>' + #13#10 +
  '						<xs:attribute name="AnalysisTypeOID" type="xs:string"/>' + #13#10 +
  '						<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:all>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Executing_RM_START_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Executing_RM_START_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Sample">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="AnalysisOID" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="StartTime" type="xs:dateTime" use="required"/>' + #13#10 +
  '								<xs:attribute name="EndTime" type="xs:dateTime" use="optional"/>' + #13#10 +
  '								<xs:attribute name="Running" type="xs:boolean" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Executing_RM_STOP_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Executing_RM_STOP_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="1" maxOccurs="1" name="Sample">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="EndTime" type="xs:dateTime" use="required"/>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '						<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Executing_RM_GET_CONTEXT: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Executing_RM_GET_CONTEXT: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:all>' + #13#10 +
  '				<xs:element name="ServersList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:simpleContent>' + #13#10 +
  '										<xs:extension base="xs:string">' + #13#10 +
  '											<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '										</xs:extension>' + #13#10 +
  '									</xs:simpleContent>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '				<xs:element name="AnalysisList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence minOccurs="0" maxOccurs="unbounded">' + #13#10 +
  '							<xs:element name="Analysis">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:sequence minOccurs="0" maxOccurs="unbounded">' + #13#10 +
  '										<xs:element name="Sample">' + #13#10 +
  '											<xs:complexType>' + #13#10 +
  '												<xs:sequence minOccurs="0" maxOccurs="unbounded">' + #13#10 +
  '													<xs:element name="Event">' + #13#10 +
  '														<xs:complexType>' + #13#10 +
  '															<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="Timestamp" type="xs:dateTime" use="required"/>' + #13#10 +
  '															<xs:attribute name="Source" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="PeerName" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="Type" type="xs:string" use="required"/>' + #13#10 +
  '															<xs:attribute name="Description" type="xs:string" use="required"/>' + #13#10 +
  '														</xs:complexType>' + #13#10 +
  '													</xs:element>' + #13#10 +
  '												</xs:sequence>' + #13#10 +
  '												<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '												<xs:attribute name="StartTime" type="xs:dateTime" use="required"/>' + #13#10 +
  '												<xs:attribute name="EndTime" type="xs:dateTime" use="optional"/>' + #13#10 +
  '												<xs:attribute name="Running" type="xs:boolean" use="required"/>' + #13#10 +
  '											</xs:complexType>' + #13#10 +
  '										</xs:element>' + #13#10 +
  '									</xs:sequence>' + #13#10 +
  '									<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="Name" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="Description" type="xs:string" use="optional"/>' + #13#10 +
  '									<xs:attribute name="AnalysisType" type="xs:string" use="required"/>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '						<xs:attribute name="SampleCount" type="xs:string" use="required"/>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:all>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Executing_RM_EDIT_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Executing_RM_EDIT_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:all>' + #13#10 +
  '				<xs:element name="AnalysisTypeList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="AnalysisType">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:simpleContent>' + #13#10 +
  '										<xs:extension base="xs:string">' + #13#10 +
  '											<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Description" type="xs:string"/>' + #13#10 +
  '										</xs:extension>' + #13#10 +
  '									</xs:simpleContent>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '				<xs:element name="ServerList">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:simpleContent>' + #13#10 +
  '										<xs:extension base="xs:string">' + #13#10 +
  '											<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '											<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '										</xs:extension>' + #13#10 +
  '									</xs:simpleContent>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '				<xs:element minOccurs="0" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence minOccurs="1" maxOccurs="1">' + #13#10 +
  '							<xs:element minOccurs="1" maxOccurs="1" name="Servers">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:sequence>' + #13#10 +
  '										<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '											<xs:complexType>' + #13#10 +
  '												<xs:simpleContent>' + #13#10 +
  '													<xs:extension base="xs:string">' + #13#10 +
  '														<xs:attribute name="OID" use="required"/>' + #13#10 +
  '													</xs:extension>' + #13#10 +
  '												</xs:simpleContent>' + #13#10 +
  '											</xs:complexType>' + #13#10 +
  '										</xs:element>' + #13#10 +
  '									</xs:sequence>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '						<xs:attribute name="Name" type="xs:string"/>' + #13#10 +
  '						<xs:attribute name="Description" type="xs:string"/>' + #13#10 +
  '						<xs:attribute name="AnalysisTypeOID" type="xs:string"/>' + #13#10 +
  '						<xs:attribute name="OID" type="xs:string"/>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:all>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_Executing_RM_GET_SERVERS_STATUS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_Executing_RM_GET_SERVERS_STATUS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence minOccurs="1" maxOccurs="1">' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Servers">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:sequence>' + #13#10 +
  '										<xs:element minOccurs="0" maxOccurs="1" name="EventTypes">' + #13#10 +
  '											<xs:complexType>' + #13#10 +
  '												<xs:sequence>' + #13#10 +
  '													<xs:element minOccurs="0" maxOccurs="unbounded" name="EventType">' + #13#10 +
  '														<xs:complexType>' + #13#10 +
  '															<xs:simpleContent>' + #13#10 +
  '																<xs:extension base="xs:string">' + #13#10 +
  '																	<xs:attribute name="Name" type="xs:string" use="required"/>' + #13#10 +
  '																</xs:extension>' + #13#10 +
  '															</xs:simpleContent>' + #13#10 +
  '														</xs:complexType>' + #13#10 +
  '													</xs:element>' + #13#10 +
  '												</xs:sequence>' + #13#10 +
  '											</xs:complexType>' + #13#10 +
  '										</xs:element>' + #13#10 +
  '									</xs:sequence>' + #13#10 +
  '									<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="Name" type="xs:string" use="required"/>' + #13#10 +
  '									<xs:attribute name="Running" type="xs:boolean" use="optional"/>' + #13#10 +
  '									<xs:attribute name="Error" type="xs:string" use="optional"/>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_InsertingAnalysis_RM_SAVE_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence minOccurs="1" maxOccurs="1">' + #13#10 +
  '				<xs:element name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:sequence>' + #13#10 +
  '							<xs:element minOccurs="1" maxOccurs="1" name="ServerList">' + #13#10 +
  '								<xs:complexType>' + #13#10 +
  '									<xs:sequence>' + #13#10 +
  '										<xs:element minOccurs="0" maxOccurs="unbounded" name="Server">' + #13#10 +
  '											<xs:complexType>' + #13#10 +
  '												<xs:simpleContent>' + #13#10 +
  '													<xs:extension base="xs:string">' + #13#10 +
  '														<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '													</xs:extension>' + #13#10 +
  '												</xs:simpleContent>' + #13#10 +
  '											</xs:complexType>' + #13#10 +
  '										</xs:element>' + #13#10 +
  '									</xs:sequence>' + #13#10 +
  '								</xs:complexType>' + #13#10 +
  '							</xs:element>' + #13#10 +
  '						</xs:sequence>' + #13#10 +
  '						<xs:attribute name="AnalysisTypeOID" type="xs:string" use="required"/>' + #13#10 +
  '						<xs:attribute name="Description" type="xs:string" use="optional"/>' + #13#10 +
  '						<xs:attribute name="Name" type="xs:string" use="required"/>' + #13#10 +
  '						<xs:attribute name="OID" type="xs:string" use="optional"/>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_InsertingAnalysis_RM_SAVE_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:sequence>' + #13#10 +
  '				<xs:element minOccurs="1" maxOccurs="1" name="Analysis">' + #13#10 +
  '					<xs:complexType>' + #13#10 +
  '						<xs:simpleContent>' + #13#10 +
  '							<xs:extension base="xs:string">' + #13#10 +
  '								<xs:attribute name="Name" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="Description" type="xs:string" use="optional"/>' + #13#10 +
  '								<xs:attribute name="AnalysisTypeName" type="xs:string" use="required"/>' + #13#10 +
  '								<xs:attribute name="OID" type="xs:string" use="required"/>' + #13#10 +
  '							</xs:extension>' + #13#10 +
  '						</xs:simpleContent>' + #13#10 +
  '					</xs:complexType>' + #13#10 +
  '				</xs:element>' + #13#10 +
  '			</xs:sequence>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDIn_1611_smEventLogAnalyser_InsertingAnalysis_RM_CANCEL_NEW_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

function GetXSDOut_1611_smEventLogAnalyser_InsertingAnalysis_RM_CANCEL_NEW_ANALYSIS: String;
begin
  Result := '<?xml version="1.0"?>' + #13#10 +
  '<!--Created with Liquid XML Studio 6.1.18.0 - FREE Community Edition (http://www.liquid-technologies.com)-->' + #13#10 +
  '<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">' + #13#10 +
  '	<xs:element name="SYSMSG">' + #13#10 +
  '		<xs:complexType>' + #13#10 +
  '			<xs:anyAttribute processContents="skip"/>' + #13#10 +
  '		</xs:complexType>' + #13#10 +
  '	</xs:element>' + #13#10 +
  '</xs:schema>' + #13#10 +
  '';
end;

procedure RegisterUseCases1(piMetaModel: acMetaModel);
var
  lUseCaseTicket: acUseCaseTicket;
  lSubMachineUseCaseTicket: acUseCaseTicket;
  lStateMachine: utStateMachine;
  lSubMachineState: utSubMachineState;
  lState: utState;
  lTransition: utTransition;
begin
  NewUseCaseTicket_ucImportaConfiguracaoSistema_1327(piMetaModel);
  NewUseCaseTicket_ucCadastroNatureza_1360(piMetaModel);
  NewUseCaseTicket_ucDetalhesAtualizacaoSistema_1359(piMetaModel);
  NewUseCaseTicket_ucControleAcesso_104(piMetaModel);
  NewUseCaseTicket_ucExplorerV4_1432(piMetaModel);
  NewUseCaseTicket_ucCadastroPerfil_1963(piMetaModel);
  NewUseCaseTicket_ucCadastroUsuarioSistema_101(piMetaModel);
  NewUseCaseTicket_ucPropriedadesDoServico_1536(piMetaModel);
  NewUseCaseTicket_ucCadastroServidores_1153(piMetaModel);
  NewUseCaseTicket_ucSISMONEventLogServer_1603(piMetaModel);
  NewUseCaseTicket_ucEventLogAnalyser_1611(piMetaModel);
  NewUseCaseTicket_ucEventLogAnaliserGraphic_2603(piMetaModel);
  NewUseCaseTicket_ucCadastroAxisX_2605(piMetaModel);
  NewUseCaseTicket_ucDashBoard_2930(piMetaModel);
  
  //UseCase 'ucImportaConfiguracaoSistema'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1327');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1327');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smImportaConfiguracaoSistema';
  utState.Create(lStateMachine, 'AguardandoXML');
  utState.Create(lStateMachine, 'XMLCarregado_AlteracoesMapeadas');
  utFinalState.Create(lStateMachine, 'FinalState1');
  lStateMachine.InitialState := lStateMachine.FindState('AguardandoXML');
  lState := lStateMachine.FindState('AguardandoXML');
  lTransition := lState.NewOutgoingTransition('RM_CARREGARXML');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('XMLCarregado_AlteracoesMapeadas');
  lTransition.AddTrigger('RM_CARREGARXML');
  lTransition.AddEffect('EFFECT_CARREGARXML');
  lTransition := lState.NewOutgoingTransition('RM_IMPORTA_CONFIGURACAO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('FinalState1');
  lTransition.AddTrigger('RM_IMPORTA_CONFIGURACAO');
  lTransition.AddEffect('EFFECT_IMPORTA_CONFIGURACAO');
  
  lState := lStateMachine.FindState('XMLCarregado_AlteracoesMapeadas');
  lTransition := lState.NewOutgoingTransition('RM_APLICAR_ALTERACOES');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('FinalState1');
  lTransition.AddTrigger('RM_APLICAR_ALTERACOES');
  lTransition.AddEffect('EFFECT_APLICAR_ALTERACOES');
  
  
  
  //UseCase 'ucCadastroNatureza'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1360');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1360');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smCadastroNatureza';
  utState.Create(lStateMachine, 'stEditando');
  utState.Create(lStateMachine, 'stConsultando');
  utState.Create(lStateMachine, 'stAguardando');
  lStateMachine.InitialState := lStateMachine.FindState('stEditando');
  lState := lStateMachine.FindState('stEditando');
  lTransition := lState.NewOutgoingTransition('RM_OBTEM_CONTEXTO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_OBTEM_CONTEXTO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_SALVA_OBJETO');
  lTransition.GuardCondition := 'GUARD_ValidaObjeto';
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_SALVA_OBJETO');
  lTransition.AddEffect('EFFECT_SalvaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_VALIDA_OBJETO');
  lTransition.GuardCondition := 'GUARD_ValidaObjeto';
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_VALIDA_OBJETO');
  
  lState := lStateMachine.FindState('stConsultando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  
  lState := lStateMachine.FindState('stAguardando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  
  
  
  //UseCase 'ucDetalhesAtualizacaoSistema'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1359');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1359');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smDetalhesAtualizacaoSistema';
  utState.Create(lStateMachine, 'Executando');
  utFinalState.Create(lStateMachine, 'FinalState1');
  lStateMachine.InitialState := lStateMachine.FindState('Executando');
  lState := lStateMachine.FindState('Executando');
  lTransition := lState.NewOutgoingTransition('RM_RETORNA_XML');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('FinalState1');
  lTransition.AddTrigger('RM_RETORNA_XML');
  lTransition.AddEffect('EFFECT_RETORNA_XML');
  
  
  
  //UseCase 'ucControleAcesso'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('104');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('104');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smControleAcesso';
  utState.Create(lStateMachine, 'Inicializando');
  utState.Create(lStateMachine, 'Executando');
  lStateMachine.InitialState := lStateMachine.FindState('Inicializando');
  lState := lStateMachine.FindState('Inicializando');
  lTransition := lState.NewOutgoingTransition('RM_INICIALIZAR_INTERFACE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executando');
  lTransition.AddTrigger('RM_INICIALIZAR_INTERFACE');
  lTransition.AddEffect('EFFECT_INICIALIZAR_INTERFACE');
  
  lState := lStateMachine.FindState('Executando');
  lTransition := lState.NewOutgoingTransition('RM_CARREGAR_PERMISSOES');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_CARREGAR_PERMISSOES');
  lTransition.AddEffect('EFFECT_CARREGAR_PERMISSOES');
  lTransition := lState.NewOutgoingTransition('RM_SALVAR');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_SALVAR');
  lTransition.AddEffect('EFFECT_SALVAR');
  
  
  
  //UseCase 'ucExplorerV4'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1432');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1432');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smExplorerV4';
  utState.Create(lStateMachine, 'Aguardando');
  lStateMachine.InitialState := lStateMachine.FindState('Aguardando');
  lState := lStateMachine.FindState('Aguardando');
  lTransition := lState.NewOutgoingTransition('RM_EXECUTE_OQL');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_EXECUTE_OQL');
  lTransition.AddEffect('EFFECT_EXECUTE_OQL');
  lTransition := lState.NewOutgoingTransition('RM_GET_OBJECT_DATA');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_OBJECT_DATA');
  lTransition.AddEffect('EFFECT_GET_OBJECT_DATA');
  lTransition := lState.NewOutgoingTransition('RM_EXECUTE_SQL');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_EXECUTE_SQL');
  lTransition.AddEffect('EFFECT_EXECUTE_SQL');
  lTransition := lState.NewOutgoingTransition('RM_GET_MODEL_OBJECT_DATA');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_MODEL_OBJECT_DATA');
  lTransition.AddEffect('EFFECT_GET_MODEL_OBJECT_DATA');
  lTransition := lState.NewOutgoingTransition('RM_GET_OQL_FROM_OBJECT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_OQL_FROM_OBJECT');
  lTransition.AddEffect('EFFECT_GET_OQL_FROM_OBJECT');
  
  
  
  //UseCase 'ucCadastroPerfil'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1963');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1963');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smucCadastroPerfil';
  utState.Create(lStateMachine, 'stAguardando');
  utState.Create(lStateMachine, 'stEditando');
  utState.Create(lStateMachine, 'stConsultando');
  lStateMachine.InitialState := lStateMachine.FindState('stAguardando');
  lState := lStateMachine.FindState('stAguardando');
  lTransition := lState.NewOutgoingTransition('RM_OBTEM_CONTEXTO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_OBTEM_CONTEXTO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_EditaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_CONSULTA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_CONSULTA_OBJETO');
  lTransition.AddEffect('Effect_ConsultaObjeto');
  
  lState := lStateMachine.FindState('stEditando');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_SALVA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_SALVA_OBJETO');
  lTransition.AddEffect('Effect_SalvaObjeto');
  
  lState := lStateMachine.FindState('stConsultando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_EditaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_CONSULTA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_CONSULTA_OBJETO');
  lTransition.AddEffect('Effect_ConsultaObjeto');
  
  
  
  //UseCase 'ucCadastroUsuarioSistema'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('101');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('101');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smCadastroUsuarioSistema';
  utState.Create(lStateMachine, 'stConsultando');
  utState.Create(lStateMachine, 'stEditando');
  utState.Create(lStateMachine, 'stAguardando');
  lStateMachine.InitialState := lStateMachine.FindState('stConsultando');
  lState := lStateMachine.FindState('stConsultando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_OBTEM_CONTEXTO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_OBTEM_CONTEXTO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_SALVA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_SALVA_OBJETO');
  lTransition.AddEffect('EFFECT_SalvaObjeto');
  
  lState := lStateMachine.FindState('stEditando');
  lTransition := lState.NewOutgoingTransition('RM_OBTEM_CONTEXTO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_OBTEM_CONTEXTO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_SALVA_OBJETO');
  lTransition.GuardCondition := 'GUARD_ValidaObjeto';
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_SALVA_OBJETO');
  lTransition.AddEffect('EFFECT_SalvaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_VALIDA_OBJETO');
  lTransition.GuardCondition := 'GUARD_ValidaObjeto';
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_VALIDA_OBJETO');
  
  lState := lStateMachine.FindState('stAguardando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  
  
  
  //UseCase 'ucPropriedadesDoServico'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1536');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1536');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smPropriedadesDoServico';
  utState.Create(lStateMachine, 'Executando');
  lStateMachine.InitialState := lStateMachine.FindState('Executando');
  lState := lStateMachine.FindState('Executando');
  lTransition := lState.NewOutgoingTransition('RM_GET_SERVICE_PROPERTIES');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SERVICE_PROPERTIES');
  lTransition.AddEffect('EFFECT_GET_SERVICE_PROPERTIES');
  
  
  
  //UseCase 'ucCadastroServidores'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1153');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1153');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smCadastroServidores';
  utState.Create(lStateMachine, 'stAguardando');
  utState.Create(lStateMachine, 'stEditando');
  utState.Create(lStateMachine, 'stConsultando');
  lStateMachine.InitialState := lStateMachine.FindState('stAguardando');
  lState := lStateMachine.FindState('stAguardando');
  lTransition := lState.NewOutgoingTransition('RM_OBTEM_CONTEXTO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_OBTEM_CONTEXTO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stAguardando_RM_INCLUI_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stAguardando_RM_INCLUI_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stAguardando_RM_EXCLUI_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_EditaObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stAguardando_RM_EDITA_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stAguardando_RM_EDITA_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_CONSULTA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_CONSULTA_OBJETO');
  lTransition.AddEffect('Effect_ConsultaObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stAguardando_RM_CONSULTA_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stAguardando_RM_CONSULTA_OBJETO;
  
  lState := lStateMachine.FindState('stEditando');
  lTransition := lState.NewOutgoingTransition('RM_SALVA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_SALVA_OBJETO');
  lTransition.AddEffect('EFFECT_SalvaObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stEditando_RM_SALVA_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stEditando_RM_SALVA_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stEditando_RM_EXCLUI_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_VALIDA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_VALIDA_OBJETO');
  lTransition.AddEffect('EFFECT_ValidaObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stEditando_RM_VALIDA_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stEditando_RM_VALIDA_OBJETO;
  
  lState := lStateMachine.FindState('stConsultando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stConsultando_RM_INCLUI_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stConsultando_RM_INCLUI_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_EditaObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stConsultando_RM_EDITA_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stConsultando_RM_EDITA_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stConsultando_RM_EXCLUI_OBJETO;
  lTransition := lState.NewOutgoingTransition('RM_CONSULTA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_CONSULTA_OBJETO');
  lTransition.AddEffect('Effect_ConsultaObjeto');
  lTransition.XsdIn.XML := GetXSDIn_1153_smCadastroServidores_stConsultando_RM_CONSULTA_OBJETO;
  lTransition.XsdOut.XML := GetXSDOut_1153_smCadastroServidores_stConsultando_RM_CONSULTA_OBJETO;
  
  
  
  //UseCase 'ucSISMONEventLogServer'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1603');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1603');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smSISMONEventLogServer';
  utState.Create(lStateMachine, 'Running');
  lStateMachine.InitialState := lStateMachine.FindState('Running');
  lState := lStateMachine.FindState('Running');
  lTransition := lState.NewOutgoingTransition('RM_PROCESS_EVENTLOG');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_PROCESS_EVENTLOG');
  lTransition.AddEffect('EFFECT_PROCESS_EVENTLOG');
  
  
  
  //UseCase 'ucEventLogAnalyser'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1611');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('1611');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smEventLogAnalyser';
  utState.Create(lStateMachine, 'Initializing');
  utState.Create(lStateMachine, 'Executing');
  utState.Create(lStateMachine, 'InsertingAnalysis');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('RM_GET_CONTEXT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_GET_CONTEXT');
  lTransition.AddEffect('EFFECT_GET_CONTEXT');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Initializing_RM_GET_CONTEXT;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Initializing_RM_GET_CONTEXT;
  
  lState := lStateMachine.FindState('Executing');
  lTransition := lState.NewOutgoingTransition('RM_NEW_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('InsertingAnalysis');
  lTransition.AddTrigger('RM_NEW_ANALYSIS');
  lTransition.AddEffect('EFFECT_NEW_ANALYSIS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Executing_RM_NEW_ANALYSIS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Executing_RM_NEW_ANALYSIS;
  lTransition := lState.NewOutgoingTransition('RM_START_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_START_ANALYSIS');
  lTransition.AddEffect('EFFECT_START_ANALYSIS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Executing_RM_START_ANALYSIS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Executing_RM_START_ANALYSIS;
  lTransition := lState.NewOutgoingTransition('RM_STOP_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_STOP_ANALYSIS');
  lTransition.AddEffect('EFFECT_STOP_ANALYSIS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Executing_RM_STOP_ANALYSIS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Executing_RM_STOP_ANALYSIS;
  lTransition := lState.NewOutgoingTransition('RM_GET_CONTEXT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_CONTEXT');
  lTransition.AddEffect('EFFECT_GET_CONTEXT');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Executing_RM_GET_CONTEXT;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Executing_RM_GET_CONTEXT;
  lTransition := lState.NewOutgoingTransition('RM_EDIT_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('InsertingAnalysis');
  lTransition.AddTrigger('RM_EDIT_ANALYSIS');
  lTransition.AddEffect('EFFECT_EDIT_ANALYSIS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Executing_RM_EDIT_ANALYSIS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Executing_RM_EDIT_ANALYSIS;
  lTransition := lState.NewOutgoingTransition('RM_GET_SERVERS_STATUS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SERVERS_STATUS');
  lTransition.AddEffect('EFFECT_GET_SERVERS_STATUS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_Executing_RM_GET_SERVERS_STATUS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_Executing_RM_GET_SERVERS_STATUS;
  lTransition := lState.NewOutgoingTransition('RM_GET_SAMPLE_EVENTS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SAMPLE_EVENTS');
  lTransition.AddEffect('EFFECT_GET_SAMPLE_EVENTS');
  lTransition := lState.NewOutgoingTransition('RM_NOTIFY_MONITOR_PARAMETERS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_NOTIFY_MONITOR_PARAMETERS');
  lTransition.AddEffect('EFFECT_NOTIFY_MONITOR_PARAMETERS');
  lTransition := lState.NewOutgoingTransition('RM_GET_EVENT_CONTENT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_EVENT_CONTENT');
  lTransition.AddEffect('EFFECT_GET_EVENT_CONTENT');
  
  lState := lStateMachine.FindState('InsertingAnalysis');
  lTransition := lState.NewOutgoingTransition('RM_SAVE_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_SAVE_ANALYSIS');
  lTransition.AddEffect('EFFECT_SAVE_ANALYSIS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_InsertingAnalysis_RM_SAVE_ANALYSIS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_InsertingAnalysis_RM_SAVE_ANALYSIS;
  lTransition := lState.NewOutgoingTransition('RM_CANCEL_NEW_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_CANCEL_NEW_ANALYSIS');
  lTransition.AddEffect('EFFECT_CANCEL_NEW_ANALYSIS');
  lTransition.XsdIn.XML := GetXSDIn_1611_smEventLogAnalyser_InsertingAnalysis_RM_CANCEL_NEW_ANALYSIS;
  lTransition.XsdOut.XML := GetXSDOut_1611_smEventLogAnalyser_InsertingAnalysis_RM_CANCEL_NEW_ANALYSIS;
  
  
  
  //UseCase 'ucEventLogAnaliserGraphic'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('2603');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('2603');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smEventLogAnaliserGraphic';
  utState.Create(lStateMachine, 'Initializing');
  utState.Create(lStateMachine, 'Executing');
  utState.Create(lStateMachine, 'InsertingAnalysis');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('RM_GET_CONTEXT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_GET_CONTEXT');
  lTransition.AddEffect('EFFECT_GET_CONTEXT');
  
  lState := lStateMachine.FindState('Executing');
  lTransition := lState.NewOutgoingTransition('RM_NEW_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('InsertingAnalysis');
  lTransition.AddTrigger('RM_NEW_ANALYSIS');
  lTransition.AddEffect('EFFECT_NEW_ANALYSIS');
  lTransition := lState.NewOutgoingTransition('RM_START_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_START_ANALYSIS');
  lTransition.AddEffect('EFFECT_START_ANALYSIS');
  lTransition := lState.NewOutgoingTransition('RM_STOP_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_STOP_ANALYSIS');
  lTransition.AddEffect('EFFECT_STOP_ANALYSIS');
  lTransition := lState.NewOutgoingTransition('RM_GET_CONTEXT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_CONTEXT');
  lTransition.AddEffect('EFFECT_GET_CONTEXT');
  lTransition := lState.NewOutgoingTransition('RM_EDIT_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('InsertingAnalysis');
  lTransition.AddTrigger('RM_EDIT_ANALYSIS');
  lTransition.AddEffect('EFFECT_EDIT_ANALYSIS');
  lTransition := lState.NewOutgoingTransition('RM_GET_SERVERS_STATUS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SERVERS_STATUS');
  lTransition.AddEffect('EFFECT_GET_SERVERS_STATUS');
  lTransition := lState.NewOutgoingTransition('RM_GET_SAMPLE_EVENTS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SAMPLE_EVENTS');
  lTransition.AddEffect('EFFECT_GET_SAMPLE_EVENTS');
  lTransition := lState.NewOutgoingTransition('RM_NOTIFY_MONITOR_PARAMETERS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_NOTIFY_MONITOR_PARAMETERS');
  lTransition.AddEffect('EFFECT_NOTIFY_MONITOR_PARAMETERS');
  lTransition := lState.NewOutgoingTransition('RM_GET_EVENT_CONTENT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_EVENT_CONTENT');
  lTransition.AddEffect('EFFECT_GET_EVENT_CONTENT');
  lTransition := lState.NewOutgoingTransition('RM_GET_ANALYSIS_GRAPHIC');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_ANALYSIS_GRAPHIC');
  lTransition.AddEffect('EFFECT_GET_ANALYSIS_GRAPHIC');
  lTransition := lState.NewOutgoingTransition('RM_REFRESH_ANALYSIS_GRAPHIC');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_REFRESH_ANALYSIS_GRAPHIC');
  lTransition.AddEffect('EFFECT_REFRESH_ANALYSIS_GRAPHIC');
  lTransition := lState.NewOutgoingTransition('RM_UPDATE_GRAPHIC_FAIXA');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_UPDATE_GRAPHIC_FAIXA');
  lTransition.AddEffect('EFFECT_UPDATE_GRAPHIC_FAIXA');
  lTransition := lState.NewOutgoingTransition('RM_UPDATE_GRAPHIC_LEVEL');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_UPDATE_GRAPHIC_LEVEL');
  lTransition.AddEffect('EFFECT_UPDATE_GRAPHIC_LEVEL');
  lTransition := lState.NewOutgoingTransition('RM_START_SERVERS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_START_SERVERS');
  lTransition.AddEffect('EFFECT_START_SERVERS');
  lTransition := lState.NewOutgoingTransition('RM_GET_SAMPLES');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SAMPLES');
  lTransition.AddEffect('EFFECT_GET_SAMPLES');
  lTransition := lState.NewOutgoingTransition('RM_GET_SAMPLE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SAMPLE');
  lTransition.AddEffect('EFFECT_GET_SAMPLE');
  lTransition := lState.NewOutgoingTransition('RM_GET_ANALYSIS_BASE_DADOS_GRAPHIC');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_ANALYSIS_BASE_DADOS_GRAPHIC');
  lTransition.AddEffect('EFFECT_GET_ANALYSIS_BASE_DADOS_GRAPHIC');
  lTransition := lState.NewOutgoingTransition('RM_UPDATE_GRAPHIC_FAIXA_BASE_DADOS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_UPDATE_GRAPHIC_FAIXA_BASE_DADOS');
  lTransition.AddEffect('EFFECT_UPDATE_GRAPHIC_FAIXA_BASE_DADOS');
  lTransition := lState.NewOutgoingTransition('RM_UPDATE_GRAPHIC_LEVEL_BASE_DADOS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_UPDATE_GRAPHIC_LEVEL_BASE_DADOS');
  lTransition.AddEffect('EFFECT_UPDATE_GRAPHIC_LEVEL_BASE_DADOS');
  
  lState := lStateMachine.FindState('InsertingAnalysis');
  lTransition := lState.NewOutgoingTransition('RM_SAVE_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_SAVE_ANALYSIS');
  lTransition.AddEffect('EFFECT_SAVE_ANALYSIS');
  lTransition := lState.NewOutgoingTransition('RM_CANCEL_NEW_ANALYSIS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_CANCEL_NEW_ANALYSIS');
  lTransition.AddEffect('EFFECT_CANCEL_NEW_ANALYSIS');
  
  
  
  //UseCase 'ucCadastroAxisX'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('2605');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('2605');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smCadastroAxisX';
  utState.Create(lStateMachine, 'stAguardando');
  utState.Create(lStateMachine, 'stEditando');
  utState.Create(lStateMachine, 'stConsultando');
  lStateMachine.InitialState := lStateMachine.FindState('stAguardando');
  lState := lStateMachine.FindState('stAguardando');
  lTransition := lState.NewOutgoingTransition('RM_OBTEM_CONTEXTO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_OBTEM_CONTEXTO');
  lTransition.AddEffect('EFFECT_MontaContexto');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_EditaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_CONSULTA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_CONSULTA_OBJETO');
  lTransition.AddEffect('Effect_ConsultaObjeto');
  
  lState := lStateMachine.FindState('stEditando');
  lTransition := lState.NewOutgoingTransition('RM_SALVA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stConsultando');
  lTransition.AddTrigger('RM_SALVA_OBJETO');
  lTransition.AddEffect('EFFECT_SalvaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_VALIDA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_VALIDA_OBJETO');
  lTransition.AddEffect('EFFECT_ValidaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_INCLUIR_INTERVALO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_INCLUIR_INTERVALO');
  lTransition.AddEffect('Effect_IncluirIntervalo');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUIR_INTERVALO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_EXCLUIR_INTERVALO');
  lTransition.AddEffect('Effect_ExcluirIntevalo');
  lTransition := lState.NewOutgoingTransition('RM_ALTERAR_INTERVALO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_ALTERAR_INTERVALO');
  lTransition.AddEffect('Effect_AlterarIntervalo');
  
  lState := lStateMachine.FindState('stConsultando');
  lTransition := lState.NewOutgoingTransition('RM_INCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_INCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_IncluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EDITA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stEditando');
  lTransition.AddTrigger('RM_EDITA_OBJETO');
  lTransition.AddEffect('EFFECT_EditaObjeto');
  lTransition := lState.NewOutgoingTransition('RM_EXCLUI_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('stAguardando');
  lTransition.AddTrigger('RM_EXCLUI_OBJETO');
  lTransition.AddEffect('EFFECT_ExcluiObjeto');
  lTransition := lState.NewOutgoingTransition('RM_CONSULTA_OBJETO');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_CONSULTA_OBJETO');
  lTransition.AddEffect('Effect_ConsultaObjeto');
  
  
  
  //UseCase 'ucDashBoard'
  lUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('2930');
  lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);
  
  lStateMachine := lUseCaseTicket.StateMachine;
  
  lStateMachine.Name := 'smServer';
  utState.Create(lStateMachine, 'Initializing');
  lSubMachineState := utSubMachineState.Create(lStateMachine, 'UseCaseSubmachine');
  lSubMachineUseCaseTicket := piMetaModel.GetUseCaseTicketByCode('2930');
  lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);
  utFinalState.Create(lStateMachine, 'smBase_FinalState');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('READY');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition.AddTrigger('READY');
  
  lState := lStateMachine.FindState('UseCaseSubmachine');
  lTransition := lState.NewOutgoingTransition('ABORT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('smBase_FinalState');
  lTransition.AddTrigger('UM_ABORT','4');
  lTransition.AddEffect('EFFECT_Abort');
  lTransition := lState.NewOutgoingTransition('TIMEOUTCHECK');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_TIMEOUT_CHECK','16');
  lTransition.AddEffect('EFFECT_TimeOutCheck');
  lTransition := lState.NewOutgoingTransition('GETTRIGGERSFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_TRIGGERS_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetTriggersFromCurrentState');
  lTransition := lState.NewOutgoingTransition('GETXSDBYTRIGGERFROMCURRENTSTATE');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_XSD_BY_TRIGGER_FROM_CURRENT_STATE');
  lTransition.AddEffect('EFFECT_GetXSDByTriggerFromCurrentState');
  
  
  lStateMachine := lUseCaseTicket.FindStateMachine('smServer');
  lStateMachine := utSubMachineState(lStateMachine.FindState('UseCaseSubmachine')).StateMachine as acUseCaseStateMachine;
  lStateMachine.Name := 'smucDashBoard';
  utState.Create(lStateMachine, 'Initializing');
  utState.Create(lStateMachine, 'Executing');
  lStateMachine.InitialState := lStateMachine.FindState('Initializing');
  lState := lStateMachine.FindState('Initializing');
  lTransition := lState.NewOutgoingTransition('RM_GET_CONTEXT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lStateMachine.FindState('Executing');
  lTransition.AddTrigger('RM_GET_CONTEXT');
  lTransition.AddEffect('EFFECT_GET_CONTEXT');
  
  lState := lStateMachine.FindState('Executing');
  lTransition := lState.NewOutgoingTransition('RM_GET_CONTEXT');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_CONTEXT');
  lTransition.AddEffect('EFFECT_GET_CONTEXT');
  lTransition := lState.NewOutgoingTransition('RM_GET_SERVERS_STATUS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_GET_SERVERS_STATUS');
  lTransition.AddEffect('EFFECT_GET_SERVERS_STATUS');
  lTransition := lState.NewOutgoingTransition('RM_NOTIFY_MONITOR_PARAMETERS');
  lTransition.SourceState := lState;
  lTransition.TargetState := lState;
  lTransition.AddTrigger('RM_NOTIFY_MONITOR_PARAMETERS');
  lTransition.AddEffect('EFFECT_NOTIFY_MONITOR_PARAMETERS');
  
  
end;

procedure RegisterModelMappings(piMetaModelPersistenceMap: acMetaModelPersistenceMapSQL);
begin
   RegisterClassTickets1(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap){1 - 200};
   RegisterClassRelationTickets1(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap){1 - 200};
   RegisterUseCases1(piMetaModelPersistenceMap.MetaModel){1 - 100};
end;



end.
