import { Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

import sharedStyles from '../styles'

// eslint-disable-next-line
export default (theme: Theme) =>
  createStyles({
    ...sharedStyles(theme),
    gridContainer: { marginBottom: theme.spacing(1) },
    dialog: { height: '60%', width: '65%' },
    gridHeaderText: { fontWeight: 'bold' },
    stepper: { ...sharedStyles(theme).stepper, background: 'white' },
    dialogContent: {
      height: '100%',
      width: '100%',
      display: 'flex',
      flexDirection: 'column',
      alignItems: 'center',
      justifyContent: 'center',
      '& .MuiTextField-root': {
        marginBottom: theme.spacing(2),
      },
    },
  })
