import React from 'react'

import { extractNumbers } from '@agiliza/utils/method'
import { Button, TextField, Typography } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  code: string
  onChange: (value: string) => void
  onResendCode: () => void
}

const VerifyCode = (props: Props) => {
  const { classes, code, onChange } = props
  return (
    <div className={classes.dialogContent}>
      <Typography className={classes.title}>Foi enviado um código de verificação por email.</Typography>
      <TextField variant="outlined" value={code} onChange={(evt) => onChange(extractNumbers(evt.target.value))} inputProps={{ maxLength: 14 }} />
      <div style={{ display: 'flex', width: '100%', justifyContent: 'flex-end' }} onClick={props.onResendCode}>
        <Button>Re-enviar código</Button>
      </div>
    </div>
  )
}

export default withStyles(styles)(VerifyCode)
