import React from 'react'

import { maskCPFCNPJ } from '@agiliza/utils/masks'
import { TextField, Typography } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  cpf: string
  onChange: (value: string) => void
}

const VerifyCPF = (props: Props) => {
  const { classes, cpf, onChange } = props
  return (
    <div className={classes.dialogContent}>
      <Typography className={classes.title}>Informe o seu CPF</Typography>
      <TextField
        variant="outlined"
        // label="CPF"
        value={maskCPFCNPJ(cpf)}
        onChange={(evt) => onChange(evt.target.value)}
        inputProps={{ maxLength: 14 }}
      />
    </div>
  )
}

export default withStyles(styles)(VerifyCPF)
