import React from 'react'

import TextFieldWithIcon from '@agiliza/components/atoms/TextFieldWithIcon'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  password: string
  confirmPassword: string
  onChange(type: 'password' | 'confirmPassword'): (value: string) => void
}

const CreatePassword = (props: Props) => {
  const { classes, password, confirmPassword, onChange } = props
  return (
    <div className={classes.dialogContent}>
      <TextFieldWithIcon label="Senha" value={password} onChange={(evt) => onChange('password')(evt.target.value)} type="password" />
      <TextFieldWithIcon
        label="Confirmar senha"
        value={confirmPassword}
        onChange={(evt) => onChange('confirmPassword')(evt.target.value)}
        type="password"
      />
    </div>
  )
}

export default withStyles(styles)(CreatePassword)
