import { Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

import sharedStyles from '../shared-styles'

// eslint-disable-next-line
export default (theme: Theme) =>
  createStyles({
    ...sharedStyles(theme),
    contentContainer: { display: 'flex', justifyContent: 'center', width: '100%', overflowY: 'auto' },
    content: { display: 'flex', flexDirection: 'column', alignItems: 'center', width: '50%' },
    creditLinesAutocomplete: { width: '100%' },
    description: { margin: theme.spacing(2), width: '100%' },
    sliderField: { textAlign: 'center', width: '100%', marginBottom: theme.spacing(3) },
    btnContainer: { width: '100%', textAlign: 'right', marginBottom: theme.spacing(2) },
    destinationsSelect: { marginBottom: theme.spacing(2) },
  })
