import { Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

import sharedStyles from '../shared-styles'

// eslint-disable-next-line
export default (theme: Theme) =>
  createStyles({
    ...sharedStyles(theme),
    contentContainer: { display: 'flex', flexDirection: 'column', alignItems: 'center', flexGrow: 1, overflowY: 'auto' },
    content: {
      display: 'flex',
      flexDirection: 'column',
      alignItems: 'center',
      width: '25%',
      height: '100%',
    },
    cardsContainer: { display: 'flex' },
    gridItem: { display: 'flex', justifyContent: 'center' },
    tabs: { borderRight: `1px solid ${theme.palette.divider}` },
    tabWrapper: { flexDirection: 'row' },
    tabLabelIcon: { marginBottom: '0px !important', marginRight: theme.spacing(1) },
  })
