import React from 'react'

import { frameworks, genders } from '@agiliza/__mocks__/proposalData'
import { BanestesAccount, DataType } from '@agiliza/api/domain'
import AccountInputsPhoto from '@agiliza/components/templates/AccountInputsPhoto'
import { ActionType } from '@agiliza/utils/hooks/state'
import CPFCNPJField from '@agiliza/views/ProposalData/components/atoms/CPFCNPJField'
import { SelectField, SelectFieldProps } from '@curio/components'
import { FormControlLabel, Switch, TextField, TextFieldProps } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { IPIdentificationState } from '../AddUpdateDialog/state'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  state: IPIdentificationState
  actions: ActionType<IPIdentificationState>
}

const Customer = (props: Props) => {
  const { classes, state, actions } = props

  const { cpfcnpj, dataType, name, gender, hasAccount, account } = state

  const handleChangeText =
    (key: keyof IPIdentificationState): TextFieldProps['onChange'] =>
    (evt) => {
      actions.update({ [key]: evt.target.value })
    }
  const handleChangeSelect =
    (key: keyof IPIdentificationState): SelectFieldProps['onChange'] =>
    (vl) => {
      actions.update({ [key]: vl })
    }

  const handleChangeDataType =
    (key: keyof DataType): SelectFieldProps['onChange'] =>
    (vl) => {
      actions.update({ dataType: { [key]: vl } })
    }

  const handleChangeAccount =
    (type: keyof BanestesAccount): TextFieldProps['onChange'] =>
    (evt) => {
      actions.update({ account: { [type]: evt.target.value } })
    }

  const handleChangePhoto = (name: string) => {
    actions.update({ account: { cardPicture: name } })
  }

  const handleChangeValidState = (vldStt: boolean) => {}

  return (
    <form className={classes.form}>
      <SelectField
        id="framework-select-field"
        label="Enquadramento"
        value={dataType?.framework}
        onChange={handleChangeDataType('framework')}
        items={frameworks.map((fw) => ({ label: fw.name, value: fw.id }))}
        variant="outlined"
        shrink={false}
      />
      <CPFCNPJField value={cpfcnpj} onChange={handleChangeText('cpfcnpj')} />
      <TextField variant="outlined" label="Nome / Razão social" value={name || ''} onChange={handleChangeText('name')} />
      <SelectField
        id="gender-select-field"
        label="Sexo"
        value={gender}
        onChange={handleChangeSelect('gender')}
        items={genders.map((fw) => ({ label: fw.name, value: fw.id }))}
        variant="outlined"
        shrink={false}
      />
      <div className={classes.switchCardPhotoContainer}>
        <FormControlLabel
          label="Possui conta no Banestes?"
          control={
            <Switch
              checked={hasAccount}
              onChange={(_, checked) => {
                actions.update({ hasAccount: checked })
              }}
              name="has-account"
              inputProps={{ 'aria-label': 'secondary checkbox' }}
            />
          }
        />
        {hasAccount ? (
          <AccountInputsPhoto
            values={{ ...account }}
            onChanges={{ account: handleChangeAccount, photo: handleChangePhoto, validState: handleChangeValidState }}
          />
        ) : null}
      </div>
    </form>
  )
}

export default withStyles(styles)(Customer)
