import { InvolvedPerson } from '@agiliza/api/domain'

type ExtendedState = Omit<InvolvedPerson['identification'], 'type'>

export interface IPIdentificationState extends ExtendedState {
  hasAccount: boolean
}

export const initialState: IPIdentificationState = {
  id: '',
  name: '',
  cpfcnpj: '',
  gender: '',
  hasAccount: false,
  account: { agencyNumber: '', number: '', cardPicture: '' },
  dataType: { doesWithdrawal: false, framework: '' },
}
