import React from 'react'

import { ActionType } from '@agiliza/utils/hooks/state'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { CDSpousePersonalDataState } from '../SpouseData/state'
import Form from './Form'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  state: CDSpousePersonalDataState
  actions: ActionType<CDSpousePersonalDataState>
}

const SpouseAdditionalData = (props: Props) => {
  const { classes, state, actions } = props

  return (
    <div className={classes.contentContainer}>
      <div className={classes.content}>
        <Form state={state} actions={actions} />
      </div>
    </div>
  )
}

export default withStyles(styles)(SpouseAdditionalData)
