import { file } from '@agiliza/__mocks__/files'
import { SourceIncome } from '@agiliza/api/domain'

type ExtendedState = SourceIncome

export interface CustomerSourceIncomeState extends ExtendedState {}

export const initialState: CustomerSourceIncomeState =
  process.env.NODE_ENV === 'development'
    ? {
        cnpj: '78.673.133/0001-16',
        address: { cep: '29101100', city: '16', complement: 'TEST', district: 'TEST', number: '1234', state: '1', street: 'TEST', proof: file },
        admissionDate: new Date('2000-10-10'),
        companyName: 'TEST',
        mobile: '27998787411',
        position: 'TEST',
        netIncome: '2500',
        proofAddress: file,
      }
    : {
        cnpj: '',
        address: { cep: '', city: '', complement: '', district: '', number: '', state: '', street: '', proof: '' },
        admissionDate: null,
        companyName: '',
        mobile: '',
        position: '',
        netIncome: '',
        proofAddress: '',
      }
