import { connect } from 'react-redux'

import { AuthenticationContext } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as entAuthentication from '@agiliza/redux/entities/authentication'
import * as ucAuthentication from '@agiliza/redux/useCases/authentication'

export interface ConnectedProps {
  fetching: boolean
  context: AuthenticationContext
}

type StateProps = Pick<ConnectedProps, 'fetching' | 'context'>
// type DispatchProps = Pick<ConnectedProps, 'getContext'>

const mapStateToProps = (state: StoreState): StateProps => ({
  fetching: ucAuthentication.selectors.isFetching(state.useCases.authentication),
  context: entAuthentication.selectors.getContextEntities(state.entities.authentication),
})

// const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
//   bindActionCreators(
//     {
//     },
//     dispatch
//   )

export const connected = connect(mapStateToProps)
