import { InvolvedPerson } from '@agiliza/api/domain'
import { INVOLVED_PERSON_TYPES } from '@agiliza/constants/involvedPeople'

type ExtendedState = InvolvedPerson['identification']

export interface CDIdentificationState extends ExtendedState {
  hasAccount: boolean
}

export const initialState: CDIdentificationState =
  process.env.NODE_ENV === 'development'
    ? {
        id: '',
        name: 'TEST',
        cpfcnpj: '80.162.745/0001-96',
        gender: '1',
        type: INVOLVED_PERSON_TYPES['CUSTOMER'],
        hasAccount: false,
        account: { agencyNumber: '', number: '', cardPicture: '' },
        dataType: { doesWithdrawal: false, framework: '1' },
      }
    : {
        id: '',
        name: '',
        cpfcnpj: '',
        gender: '',
        type: INVOLVED_PERSON_TYPES['CUSTOMER'],
        hasAccount: false,
        account: { agencyNumber: '', number: '', cardPicture: '' },
        dataType: { doesWithdrawal: false, framework: '' },
      }
