import { file } from '@agiliza/__mocks__/files'
import { Home } from '@agiliza/api/domain'

type ExtendedState = Home

export interface CDHomeState extends ExtendedState {
  hasProperty: boolean
}
export const initialState: CDHomeState =
  process.env.NODE_ENV === 'development'
    ? {
        hasProperty: false,
        address: {
          id: '',
          cep: '29100100',
          city: '16',
          complement: 'TEST',
          district: 'TEST',
          number: '123',
          state: '1',
          street: 'TEST',
        },
        proof: file,
        cityResideTime: '12',
        deed: file,
        deedRecord: '1',
        hasOnus: false,
        marketValue: '1234',
        reside: false,
        resideTime: '10',
        type: '1',
      }
    : {
        hasProperty: true,
        address: { id: '', cep: '', city: '', complement: '', district: '', number: '', state: '', street: '' },
        proof: '',
        cityResideTime: '',
        deed: '',
        deedRecord: '',
        hasOnus: false,
        marketValue: '',
        reside: false,
        resideTime: '',
        type: '',
      }
