import React from 'react'

import { extractNumbers } from '@agiliza/utils/extractors'
import { ActionType } from '@agiliza/utils/hooks/state'
import PriceAmountInput, {
  Values
} from '@agiliza/views/ProposalData/components/templates/PriceAmountInput'
import { TextField, TextFieldProps, Typography } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { BDProductServiceState } from '../state'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  state: BDProductServiceState
  actions: ActionType<BDProductServiceState>
}

const Form = (props: Props) => {
  const { classes, state, actions } = props

  const { description, unit, stock, monthlySales, variableCosts } = state

  const handleChangeText =
    (key: keyof BDProductServiceState): TextFieldProps['onChange'] =>
    (evt) => {
      actions.update({ [key]: evt.target.value })
    }

  const handleChangePriceAmount = (keyState: keyof BDProductServiceState) => (value: Partial<Values>) => {
    actions.update({ [keyState]: value })
  }

  return (
    <form className={classes.form}>
      <TextField variant="outlined" label="Descrição do produto / serviço" value={description} onChange={handleChangeText('description')} />
      <TextField variant="outlined" label="Unidade" value={extractNumbers(unit)} onChange={handleChangeText('unit')} type="tel" />
      <Typography className={classes.label}>Informações de estoque</Typography>
      <PriceAmountInput values={stock} onChange={handleChangePriceAmount('stock')} />
      <Typography className={classes.label}>Vendas mensais</Typography>
      <PriceAmountInput values={monthlySales} onChange={handleChangePriceAmount('monthlySales')} />
      <Typography className={classes.label}>Custos variáveis</Typography>
      <PriceAmountInput values={variableCosts} onChange={handleChangePriceAmount('variableCosts')} />
    </form>
  )
}

export default withStyles(styles)(Form)
