import { file } from '@agiliza/__mocks__/files'
import { BDIdentification } from '@agiliza/api/domain'

type ExtendedState = BDIdentification

export interface BDIdentificationState extends ExtendedState {
  mainActivity: string
}

export const initialState: BDIdentificationState =
  process.env.NODE_ENV === 'development'
    ? {
        cnpj: '81.867.778/0001-02',
        activitySector: '1',
        cityRegistration: '123456',
        codeCNAE: '123456',
        companyName: 'TEST',
        document: { extraInformations: 'TEST', id: '1', url: file, type: { id: '1', description: '' } },
        fantasyName: 'TEST',
        local: '1',
        settledOP: '1',
        stateRegistration: '123456',
        commercialRegistration: '123456',
        mainActivity: 'TEST',
        openingDate: new Date('2010-10-10'),
      }
    : {
        cnpj: '',
        activitySector: '',
        cityRegistration: '',
        codeCNAE: '',
        companyName: '',
        document: { extraInformations: '', id: '', url: '', type: { id: '', description: '' } },
        fantasyName: '',
        local: '',
        settledOP: '',
        stateRegistration: '',
        commercialRegistration: '',
        mainActivity: '',
        openingDate: null,
      }
