import { file } from '@agiliza/__mocks__/files'
import { BDAddress } from '@agiliza/api/domain'

type ExtendedState = BDAddress

export interface BDAddressState extends ExtendedState {}

export const initialState: BDAddressState =
  process.env.NODE_ENV === 'development'
    ? {
        id: '',
        proof: file,
        cep: '29100100',
        city: '16',
        complement: 'TEST',
        district: 'TEST',
        number: '123',
        state: '1',
        street: 'TEST',
        referencePoint: 'TEST',
      }
    : {
        id: '',
        proof: '',
        cep: '',
        city: '',
        complement: '',
        district: '',
        number: '',
        state: '',
        street: '',
        referencePoint: '',
      }
