import React from 'react'
import { RouteComponentProps } from 'react-router'

import { Project } from '@agiliza/api/domain/project'
import { Avatar, List, ListItem, ListItemAvatar, ListItemText } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'
import { Apps as AppsIcon } from '@material-ui/icons'

import { connected, ConnectedProps } from './connect'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles> & ConnectedProps & RouteComponentProps

interface Props extends ExtendedProps {}

const ListProjects = (props: Props) => {
  const { classes, proposals } = props

  const handleClickListItem = (proposal: Project) => () => {}

  return (
    <div className={classes.pageContent}>
      <List className={classes.list}>
        {proposals.map((proposal, i) => (
          <ListItem key={i} button onClick={handleClickListItem(proposal)}>
            <ListItemAvatar>
              <Avatar>
                <AppsIcon />
              </Avatar>
            </ListItemAvatar>
            <ListItemText primary="Número da proposta" secondary={proposal.processNumber} />
          </ListItem>
        ))}
      </List>
    </div>
  )
}

export default connected(withStyles(styles)(ListProjects))
