import { combineReducers } from 'redux'

import businessData, {
  initialState as businessDataInitialState,
  State as BusinessDataState
} from './businessData'
import context, { initialState as contextInitialState, State as ContextState } from './context'
import customerData, {
  initialState as customerDataInitialState,
  State as CustomerDataState
} from './customerData'

export interface State {
  context: ContextState
  businessData: BusinessDataState
  customerData: CustomerDataState
}

export const initialState: State = {
  context: contextInitialState,
  businessData: businessDataInitialState,
  customerData: customerDataInitialState,
}

export default combineReducers({ context, businessData, customerData })
