import { createSelector } from '@reduxjs/toolkit'

import { Store } from './slice'

export const getAllIds = (key: keyof Store) => (state: Store) => {
  return state[key].allIds
}

export const getById = (key: keyof Store) => (state: Store) => {
  return state[key].byId
}

export const getSubproducts = createSelector(getById('subproducts'), getAllIds('subproducts'), (byId, allIds) => allIds.map((id) => byId[id]))
