import { createSelector } from '@reduxjs/toolkit'

import { Store } from './slice'

export const getAllIds = (key: keyof Store) => (state: Store) => {
  return state[key].allIds
}

export const getById = (key: keyof Store) => (state: Store) => {
  return state[key].byId
}

export const getSimulationCategories = createSelector(getById('simulationCategories'), getAllIds('simulationCategories'), (byId, allIds) =>
  allIds.map((id) => byId[id])
)
