import { normalize, schema } from 'normalizr'

import { ProposalDataContext } from '@agiliza/api/domain'
import { WithNormalizedEntity } from '@agiliza/utils/method'

export const PROPOSAL_DATA_PREFIX = 'entities/proposalData'

export type NormalizedContext = WithNormalizedEntity<ProposalDataContext>

const contextSchemas: Record<keyof ProposalDataContext, any> = {
  frameworks: new schema.Array(new schema.Entity('frameworks')),
  genders: new schema.Array(new schema.Entity('genders')),
  schoolings: new schema.Array(new schema.Entity('schoolings')),
  maritalStatus: new schema.Array(new schema.Entity('maritalStatus')),
  referenceTypes: new schema.Array(new schema.Entity('referenceTypes')),
  homeTypes: new schema.Array(new schema.Entity('homeTypes')),
  deedRecords: new schema.Array(new schema.Entity('deedRecords')),
  activitySectors: new schema.Array(new schema.Entity('activitySectors')),
  settledOPs: new schema.Array(new schema.Entity('settledOPs')),
  locals: new schema.Array(new schema.Entity('locals')),
  documentTypes: new schema.Array(new schema.Entity('documentTypes')),
  monthRatings: new schema.Array(new schema.Entity('monthRatings')),
}

export const normalizeContext = (context: ProposalDataContext) => {
  const { entities } = normalize(context, contextSchemas)
  const normalizedEntities = entities as unknown as NormalizedContext
  return normalizedEntities
}
