import { combineReducers } from 'redux'

import context, { initialState as contextInitState, Store as ContextStore } from './context'
import proposal, { initialState as proposalInitState, Store as ProposalStore } from './proposal'

export interface State {
  context: ContextStore
  proposal: ProposalStore
}
export const initialState: State = {
  context: contextInitState,
  proposal: proposalInitState,
}

export default combineReducers({
  context,
  proposal,
})
