import { ProposalDataContext } from '@agiliza/api/domain'
import { entries, values } from '@agiliza/utils/method'
import { createSelector } from '@reduxjs/toolkit'

import { Store } from './slice'

export const getAllIds = (key: keyof Store) => (state: Store) => {
  return state[key].allIds
}

export const getById = (key: keyof Store) => (state: Store) => {
  return state[key].byId
}

export const getFrameworks = createSelector(getById('frameworks'), getAllIds('frameworks'), (byId, allIds) => allIds.map((id) => byId[id]))
export const getContext = (state: Store) =>
  entries(state).reduce((entities, [k, v]) => {
    return { ...entities, [k]: values(v.byId) }
  }, {} as ProposalDataContext)
