import React from 'react'
import { RouteComponentProps } from 'react-router-dom'

import { Typography } from '@material-ui/core'
import { createStyles, Theme } from '@material-ui/core/styles'
import { withStyles, WithStyles } from '@material-ui/styles'

const styles = (theme: Theme) =>
  createStyles({
    container: {
      paddingLeft: theme.spacing(2),
    },
    messageBox: {
      paddingTop: theme.spacing(4),
    },
  })

type Props = WithStyles<typeof styles> & RouteComponentProps

interface NotFoundProps extends Props {}

function NotFound({ classes }: NotFoundProps) {
  return (
    <div className={classes.container}>
      <Typography variant="h3">404: Página não encontrada</Typography>
      <div className={classes.messageBox}>
        <Typography variant="h5">A página pela qual você procurou não existe.</Typography>
      </div>
    </div>
  )
}

export default /*#__PURE__*/ withStyles(styles)(NotFound)
