import React from 'react'

import { maskPhone } from '@agiliza/utils/masks'
import { TextField, TextFieldProps } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = WithStyles<typeof styles>

interface Props extends ExtendedProps {
  value?: string
  onChange: TextFieldProps['onChange']
  label?: string
}

const PhoneField = (props: Props) => {
  const { label, value, onChange } = props
  return <TextField variant="outlined" label="Telefone" value={label || maskPhone(value)} onChange={onChange} inputProps={{ maxLength: 15 }} />
}

export default withStyles(styles)(PhoneField)
