import { Operations } from '@dynamo/utils'

export const DYNAMO_ENTITIES = {
  TermsOfAcceptance: '1',
  Profile: '5',
  User: '6',
}

export const DYNAMO_TRANSITIONS = {
  menu: '116',
  presentation: '134',
  search: '120',
} as const

export type DynamoMetadata = {
  [key in Operations]?: string
} & { useCase: number; fetch: string }

export const USER_METADATA = {
  useCase: 101,
  save: 'RM_SALVA_OBJETO',
  getContext: 'RM_OBTEM_CONTEXTO',
  createObject: 'RM_INCLUI_OBJETO',
  editObject: 'RM_EDITA_OBJETO',
  disable: 'RM_EXCLUI_OBJETO',
} as const

export const PROFILE_METADATA = {
  useCase: 1963,
  save: 'RM_SALVA_OBJETO',
  getContext: 'RM_OBTEM_CONTEXTO',
  createObject: 'RM_INCLUI_OBJETO',
  editObject: 'RM_EDITA_OBJETO',
  deleteObject: 'RM_EXCLUI_OBJETO',
  // getTransitions: 'RM_GET_TRIGGERS_FROM_CURRENT_STATE',
} as const
