interface JavaConfig {
  API_URL: string
  APP_NAME_BROKER: string
  APP_NAME_CUSTOMER: string
  SESSION_KEY_BROKER: string
  SESSION_KEY_CUSTOMER: string
}

const JAVA_CONFIG_PATH = './config.json'

let javaConfig: JavaConfig

export const getJavaConfig = async () => {
  if (!javaConfig) {
    try {
      javaConfig = await (await fetch(JAVA_CONFIG_PATH)).json()
      return javaConfig
    } catch (e) {
      if (e instanceof Response) {
        //Not found, most likely
        throw process.env.NODE_ENV === 'production'
          ? 'Não foi encontrado o arquivo config.json na raiz da aplicação.'
          : 'Arquivo config.json faltando na pasta public.'
      }
      throw e
    }
  }
}
