import { Entity } from '@agiliza/utils/method'

export interface Reference extends Entity {
  photo: string
  type: string
  name: string
  telephone: string
  extraInfo: string
  concept: string
}

interface InputGetReferences {
  projectId: string
  personId: string
}

export interface GetCDReferences {
  Input: InputGetReferences
  Output: Reference[]
}

interface InputAddCDReference {
  projectId: string
  personId: string
  reference: Reference
}

export interface AddCDReference {
  Input: InputAddCDReference
  Output: Reference[]
}

interface InputUpdateCDReference {
  projectId: string
  personId: string
  referenceId: string
  reference: Reference
}

export interface UpdateCDReference {
  Input: InputUpdateCDReference
  Output: Reference[]
}
