import { InvolvedPerson, RG } from './index'

export interface PersonalData {
  rg?: RG
  birthday: Date | null
  userCRAS: boolean
  participationPercentage?: number
  mothersName: string
  fathersName: string
  occupation: string
  schooling: string
  maritalStatus: string
  dependents: string
  primaryEmail: string
  secundaryEmail: string
  mobile: string
  landline: string
}

export interface UpdatePersonalDataArgs {
  projectId: string
  personId: string
  personalData: InvolvedPerson['personalData']
}

interface InputUpdateCDPersonalData {
  personalData: PersonalData
  projectId: string
  personId: string
}

export interface UpdateCDPersonalData {
  Input: InputUpdateCDPersonalData
  Output: PersonalData
}
