import { Entity } from '@agiliza/utils/method'

import { Customer } from '../'

export interface City extends Entity {
  name: string
  state: string
}

export interface State extends Entity {
  name: string
  acronym: string
}

export interface AuthenticationContext {
  states: State[]
  cities: City[]
}

type OutputGetContext = AuthenticationContext

export interface GetContext {
  Input: void
  Output: OutputGetContext
}

interface InputVerifyCPF {
  cpf: string
}

export interface VerifyCPF {
  Input: InputVerifyCPF
  Output: void
}

interface InputCreateCustomer {
  cpf: string
  name: string
  email: string
  phone: string
  cep: string
  street: string
  number: string
  complement: string
  district: string
  state: string
  city: string
}

interface OutputCreateCustomer {
  customer: Customer
}

export interface CreateCustomer {
  Input: InputCreateCustomer
  Output: OutputCreateCustomer
}

interface InputSendCode {
  cpf: string
  email: string
}

export interface SendCode {
  Input: InputSendCode
  Output: void
}

interface InputVerifyCode {
  code: string
  cpf: string
}

export interface VerifyCode {
  Input: InputVerifyCode
  Output: void
}

interface InputCreatePassword {
  password: string
  code: string
  cpf: string
}

export interface CreatePassword {
  Input: InputCreatePassword
  Output: void
}

export interface GetLoggedCustomer {
  Input: void
  Output: Customer
}
