import { CodigoDescricao, IdDescricao } from '@agiliza/api/domain'
import { Entity } from '@agiliza/utils/method'

export interface DomainAdapter<A, B> {
  mapApiModelToDomain(apiModel: A): B
}

interface IdDescription extends Entity {
  description: string
}

export class IdDescriptionMapper implements DomainAdapter<IdDescricao, IdDescription> {
  public mapApiModelToDomain = (iD: Partial<IdDescricao>): IdDescription => ({
    id: iD.id || '',
    description: iD.descricao || '',
  })
}

export class CodeDescriptionMapper implements DomainAdapter<CodigoDescricao, IdDescription> {
  public mapApiModelToDomain = (iD: Partial<CodigoDescricao>): IdDescription => ({
    id: iD.codigo || '',
    description: iD.descricao || '',
  })
}
