import { Broker } from '@agiliza/api/domain'
import { UsuarioApiModel } from '@microcredito/client'

import { DomainAdapter } from './shared'

export class BrokerMapper implements DomainAdapter<UsuarioApiModel, Broker> {
  public mapApiModelToDomain = ({ usuarioAgente }: UsuarioApiModel): Broker => ({
    cpf: usuarioAgente?.cpf || '',
    operatingCity: usuarioAgente?.municipioDeAtuacao || '',
    profilePicture: usuarioAgente?.fotoPerfil || '',
    name: usuarioAgente?.nome || '',
    phone: usuarioAgente?.celular || '',
    email: usuarioAgente?.email || '',
  })
}
