import { GetProjects } from '@agiliza/api/domain'
import { BuscarProjetosRequest } from '@microcredito/client/dist/apis/AgenteApi'

import { ApiAdapter } from '../shared'

export class GetProjectsApiMapper implements ApiAdapter<GetProjects['Input'], BuscarProjetosRequest> {
  public mapDomainToApiModel = (input: GetProjects['Input']): BuscarProjetosRequest => ({
    obterProjetosRequestApiModel: {
      filtros: {
        dataInicio: input.beginDate || undefined,
        dataFim: input.endDate || undefined,
        codigosFases: input.statuses?.length ? input.statuses : undefined,
      },
    },
  })
}
