import { Entity } from '@agiliza/utils/method'

export interface SubProduct extends Entity {
  description?: string
  fee?: number
  IOF?: number
  maxAmountInstallment?: number
  installementOptions: InstallmentOption[]
  TAC?: number
}

export interface GetSubProducts {
  Input: InputGetSubProducts
  Output: OutputGetSubProducts
}

interface InputGetSubProducts {
  creditValue: number
  categoryId: string
  gracePeriodId: string
  installmentsNumber: number
}

type OutputGetSubProducts = SubProduct[]

export interface InstallmentOption extends Entity {
  installmentAmount?: number
  installmentValue?: number
  netValue?: number
}

interface InputCreateProposal {
  creditValue: number
  gracePeriodId: number
  categoryId: string
  installmentsNumber: number
  subproductId: string
}

export interface CreateProposal {
  Input: InputCreateProposal
  Output: string
}

interface InputSendProposal {
  proposalId: string
}

export interface SendProposal {
  Input: InputSendProposal
  Output: void
}
