import { Entity } from '@agiliza/utils/method'

import { Document } from './project'
import { Address } from './user'

export interface Schedule extends Entity {
  status: ScheduleStatus
  events: string[]
  documents?: Document[]
  number: string
  date: Date
  permissions?: SchedulePermissions
  requestReschedule?: RequestReschedule
  requestCancel?: RequestCancel
}

interface RequestReschedule {
  idReason: string
  justification: string
  date: Date | null
}

interface RequestCancel {
  idReason: string
  justification: string
}

export interface CreditInformation {
  creditValue: string
  creditObjective: string
  creditInstallment: string
  creditGracePeriod: string
}

export interface ScheduleTime {
  dateTime: Date // must be converted to ISO string
  documentFront: string //Base64 data
  documentBack: string //Base 64 data
}

export interface ScheduleVisit {
  address: Address
  creditInformation: CreditInformation
  scheduleTime: ScheduleTime
}

export interface SchedulePermissions {
  requestCancel?: boolean
  requestReschedule?: boolean
  confirmReschedule?: boolean
}

export interface ScheduleStatus extends Entity {
  description: string
  operations: Operation[]
}

interface Operation {
  id: string
  description: string
  descriptionTransition: string
  permission: 'customer' | 'broker'
}

export interface RequestCancelSchedule {
  idSchedule: string
  idReason: string
  explanationDescription: string
}

export interface RequestRescheduleInfo {
  idSchedule: string
  idReason: string
  description?: string
  date: Date
}

export interface FetchDocumentsArg {
  projectId: string
  visitId?: string
}

export interface PermissionResponse {
  permission: boolean
  projectId?: string
  visitId?: string
}
