import { Entity } from '@agiliza/utils/method'

export interface Vehicle extends Entity {
  licensePlate: string
  model: string
  brand: string
  year: string
  marketValue: string
  hasOnus: boolean
  hasInsurance: boolean
  document: string
}

export interface AddVehicleArgs {
  projectId: string
  personId: string
  vehicle: Vehicle
}
export interface UpdateVehicleArgs {
  projectId: string
  personId: string
  vehicleId: string
  vehicle: Vehicle
}

export interface DeleteVehicleArgs {
  projectId: string
  personId: string
  vehicleId: string
}

interface InputGetCDVehicles {
  projectId: string
  personId: string
}

export interface GetCDVehicles {
  Input: InputGetCDVehicles
  Output: Vehicle[]
}

interface InputAddCDVehicles {
  projectId: string
  personId: string
  vehicle: Vehicle
}

export interface AddCDVehicle {
  Input: InputAddCDVehicles
  Output: Vehicle[]
}

interface InputUpdateCDVehicles {
  projectId: string
  personId: string
  vehicleId: string
  vehicle: Vehicle
}

export interface UpdateCDVehicle {
  Input: InputUpdateCDVehicles
  Output: Vehicle[]
}
