import { Entity } from '@agiliza/utils/method'

import type { InvolvedPerson, BusinessData } from './projectElaboration'
import type { Schedule } from './schedule'

import type { UserCustomer } from './user'

export * from './context'

export interface Project extends Entity {
  status: ProjectStatus
  events: string[]
  documents?: Document[]
  processNumber: string
  permissions?: ProjectPermissions
  schedules: Schedule[]
  // customer: UserCustomer
  // involvedPeople?: InvolvedPerson[]
  // businessData?: BusinessData
}

export interface ProjectStatus extends Entity {
  description: string
  operations?: Operation[]
}

export interface Operation extends Entity {
  description: string
  descriptionTransition: string
  permission: 'customer' | 'broker'
}

export interface ProjectPermissions {
  requestCancel?: boolean
}

export interface Document {
  id: string
  type: DocumentType
  extraInformations: string
  url: string
}

export interface DocumentType extends Entity {
  description: string
}

export interface FetchDocumentsArg {
  projectId: string
  visitId?: string
}

interface InputGetProjects {
  beginDate: Date | null
  endDate: Date | null
  statuses?: number[]
}

export interface GetProjects {
  Input: InputGetProjects
  Output: Project[]
}

interface InputSubmitProjects {
  ids: string[]
}

export interface SubmitProjects {
  Input: InputSubmitProjects
  Output: void
}
