import { Entity } from '@agiliza/utils/method'

export * from './proposalData'
export * from './context'
export * from './error'
export * from './simulation'
export * from './authentication'
export * from './user'
export * from './project'

export interface User {
  name: string
  email: string
  ownerName?: string
  ownerCPF?: string
  cpfcnpj: string
  phone: string
  avatarUrl?: string
  address?: Partial<Address>
  profilePicture?: string
}

export interface IdDescricao {
  id: string
  descricao: string
}

export interface CodigoDescricao {
  codigo: string
  descricao: string
}

export interface DocumentType extends Entity {
  description: string
}
