﻿unit svuAgiliza;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses acuServiceApplication, acuRepositorySQL, acuModel;

type
  svAgiliza = class(acServiceApplication)
  private
    fModel: acMetaModel;
    fMetaModelPersistenceMap: acMetaModelPersistenceMapSQL;

  protected
    procedure DoInitialize; override;
    procedure DoStart; override;
    procedure DoStop; override;
    procedure DoPause; override;
    procedure DoContinue; override;
    procedure DoCheck; override;
  end;

  function Application: svAgiliza;

implementation

uses
  {$IFDEF FPC} acuQuerySQLODBC, {$ELSE} acuQuerySQLADO, {$ENDIF}
  acuObject, acuSystemConfig, acuRegisterModelMappings,
  acuFramework, acuSystemCurrentConfig;

var
  FApplication: svAgiliza;

function Application: svAgiliza;
begin
  if not Assigned(FApplication)
    then FApplication := svAgiliza.Create(Nil);
  Result := FApplication;
end;


{ svAgiliza }

procedure svAgiliza.DoCheck;
const INCOSISTENCIA: String = 'InconsistÃªncia(s) encontrada(s) na implementaÃ§Ã£o do modelo:';
begin
  inherited;
end;

procedure svAgiliza.DoContinue;
begin
  inherited;
end;

procedure svAgiliza.DoInitialize;
begin
  inherited;

  acSystemConfig.Instance.Load(acUtils.ChangeFileExt(ParamStr(0), '.config'));
  acSystemCurrentConfig.Instance.LoadFrom(acSystemConfig.Instance);

  fModel := acuModel.acMetaModel.Create(PersistenceManager.ModelImplementation);
  fMetaModelPersistenceMap := acMetaModelPersistenceMapSQL.Create(fModel);

  acRepositorySQL.DefaultDatabaseDriver := typeof({$IFDEF FPC} acuQuerySQLODBC.acDatabaseSQLODBC {$ELSE} acuQuerySQLADO.acDatabaseSQLADO {$ENDIF});

  PersistenceManager.RegisterModelMapping(fMetaModelPersistenceMap);

  acuRegisterModelMappings.RegisterModelMappings(fMetaModelPersistenceMap);
  PersistenceManager.Initialize;

  acPersistenceManager.Instance.DefaultConnetionString := acSystemConfig.Instance.ParamByName('Application.Database.' + acSystemConfig.Instance.ParamByName('Application.Database.@ActiveConnectionString'));
end;

procedure svAgiliza.DoPause;
begin
  inherited;

end;

procedure svAgiliza.DoStart;
begin
  inherited;

end;

procedure svAgiliza.DoStop;
begin
  inherited;
end;

initialization

finalization
  Application.Free;

end.
