import { connect } from 'react-redux'
import { bindActionCreators, Dispatch } from 'redux'

import { Customer } from '@agiliza/api/domain'
import { StoreState } from '@agiliza/redux'
import * as session from '@agiliza/redux/session'
import * as uiLogin from '@agiliza/redux/ui/login'

export interface ConnectedProps {
  fetching: boolean
  login: typeof uiLogin.actions.login
  customer?: Customer
}

type StateProps = Pick<ConnectedProps, 'fetching' | 'customer'>
type DispatchProps = Pick<ConnectedProps, 'login'>

const mapStateToProps = (state: StoreState): StateProps => ({
  fetching: uiLogin.selectors.isFetching(state.ui.login),
  customer: session.selectors.getCustomer(state.session),
})

const mapDispatchToProps = (dispatch: Dispatch): DispatchProps =>
  bindActionCreators(
    {
      login: uiLogin.actions.login,
    },
    dispatch
  )

export const connected = connect(mapStateToProps, mapDispatchToProps)
