import React, { useState } from 'react'

import ButtonWithProgress from '@agiliza/components/atoms/ButtonWithProgress'
import LoginTemplate from '@agiliza/components/templates/Login'
import { formatCPF } from '@agiliza/utils/formatters'
import { extractNumbers } from '@agiliza/utils/method'
import { Button, TextFieldProps, Typography } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import { connected, ConnectedProps } from './connect'
import FirstAccessDialog from './FirstAccessDialog'
import styles from './styles'

// interface UserFormFieldProps extends Pick<TextFieldProps, 'label' | 'value' | 'onChange' | 'error' | 'helperText' | 'inputProps'> {}

// const UserFormField = ({ helperText, ...props }: UserFormFieldProps) => <TextField fullWidth margin="normal" variant="outlined" {...props} />

interface State {
  username: string
  password: string
}

// const validators: Validators<Partial<State>> = {
//   phoneNumber: (vl) => (isValidPhone(vl) ? validState(vl) : invalidState(vl, '')),
//   email: (vl) => (isValidEmail(vl) ? validState(vl) : invalidState(vl, '')),
// }

type ExtendedProps = WithStyles<typeof styles> & ConnectedProps

interface Props extends ExtendedProps {}

const UserForm = (props: Props) => {
  const { classes, fetching, customer } = props
  const [state, setState] = useState<State>({ username: '', password: '' })
  const { username, password } = state
  const [open, setOpen] = useState(false)

  // const { errorState, validState: isValidState, actions } = useErrorValidator({ username: '', password: '' })

  // useEffect(() => {
  //   onChangeCanGoForward(isValidState)
  // }, [isValidState])

  const handleChange =
    (key: keyof State): TextFieldProps['onChange'] =>
    (evt) => {
      setState({ ...state, [key]: evt.target.value })
      // actions.validate({ [key]: evt.target.value })
    }

  return (
    <div className={classes.contentContainer}>
      <div className={classes.content}>
        <Typography>Identifique-se</Typography>
        <LoginTemplate username={formatCPF(username)} password={password} onChange={handleChange} />
        <ButtonWithProgress
          className={classes.btn}
          fetching={fetching}
          disabled={!username || !!customer}
          color="secondary"
          onClick={() =>
            props.login({
              username: extractNumbers(username),
              password,
            })
          }
        >
          {!customer ? 'Identificar' : 'Identificado'}
        </ButtonWithProgress>
        <Button variant="contained" className={classes.btn} color="secondary" onClick={() => setOpen(true)} disabled={!!customer}>
          Primeiro aceeso
        </Button>
        {/* <UserFormField label="Nome" value={name} onChange={handleChange('name')} {...getErrorProps(errorState.name)} />
        <UserFormField
          label="Número de celular"
          value={formatPhone(phoneNumber)}
          onChange={handleChange('phoneNumber')}
          inputProps={{ maxLength: 15 }}
          {...getErrorProps(errorState.phoneNumber)}
        />
        <UserFormField label="Email" value={email} onChange={handleChange('email')} {...getErrorProps(errorState.email)} /> */}
      </div>
      <FirstAccessDialog open={open} onClose={() => setOpen(false)} />
    </div>
  )
}

export default connected(withStyles(styles)(UserForm))
