import React from 'react'

import { InstallmentOption } from '@agiliza/api/domain'
import { formatCurrency } from '@agiliza/utils/formatters'
import {
  Button,
  Dialog,
  DialogActions,
  DialogContent,
  DialogProps,
  DialogTitle,
  Grid,
  Typography
} from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'

import styles from './styles'

type ExtendedProps = Pick<DialogProps, 'open'> & WithStyles<typeof styles>

interface Props extends ExtendedProps {
  onClose: () => void
  installmentOptions?: InstallmentOption[]
}

const InstallmentsDialog = (props: Props) => {
  const { classes, open, onClose, installmentOptions } = props

  return (
    <Dialog onClose={onClose} aria-labelledby="simple-dialog-title" open={open} PaperProps={{ className: classes.dialog }}>
      <DialogTitle>Tipos de parcelamento</DialogTitle>
      <DialogContent>
        <Grid container className={classes.gridContainer}>
          <Grid item xs={6}>
            <Typography className={classes.gridHeaderText}>Número de parcelas</Typography>
          </Grid>
          <Grid item xs={3}>
            <Typography className={classes.gridHeaderText}>Valor parcela</Typography>
          </Grid>
          <Grid item xs={3}>
            <Typography className={classes.gridHeaderText}>Valor total</Typography>
          </Grid>
        </Grid>
        {installmentOptions?.map((iO) => (
          <Grid container item xs={12} key={iO.id}>
            <Grid item xs={6}>
              {iO.installmentAmount && `${iO.installmentAmount || ''} parcela${iO.installmentAmount > 1 ? 's' : ''}`}
            </Grid>
            <Grid item xs={3}>
              {formatCurrency(iO.installmentValue?.toString() || '')}
            </Grid>
            <Grid item xs={3}>
              {formatCurrency(iO.netValue?.toString() || '')}
            </Grid>
            {/* <GridLine label="Número de parcelas" value={iO.installmentAmount || ''} />
              <GridLine label="Valor de cada parcela" value={iO.installmentValue || ''} />
              <GridLine label="Valor total" value={iO.netValue || ''} /> */}
          </Grid>
        ))}
      </DialogContent>
      <DialogActions>
        <Button onClick={onClose}>Fechar</Button>
      </DialogActions>
    </Dialog>
  )
}

export default withStyles(styles)(InstallmentsDialog)
