import React from 'react'

import { Grid, Typography } from '@material-ui/core'

type ExtendedProps = Record<string, unknown>

interface Props extends ExtendedProps {
  label: string
  value: string | number
}

const GridLine = (props: Props) => {
  const { label, value } = props
  return (
    <>
      <Grid item xs={10}>
        <Typography variant="h5">{label}</Typography>
      </Grid>
      <Grid item xs={2} style={{ whiteSpace: 'nowrap' }}>
        <Typography variant="h5">{value}</Typography>
      </Grid>
    </>
  )
}

export default GridLine
