import React from 'react'

import { Slider, SliderProps, TextField, TextFieldProps, Typography } from '@material-ui/core'

type ExtendedProps = Record<string, unknown>

interface Props extends ExtendedProps {
  title: string
  valueField: string
  sliderProps?: Pick<SliderProps, 'min' | 'max' | 'marks' | 'step'> & {
    onChange: (event: React.ChangeEvent<Record<string, unknown>>, value: number | number[]) => void
    value: number
  }
  disabled: boolean
  onChangeField: TextFieldProps['onChange']
  onBlurField: TextFieldProps['onBlur']
  className?: string
  suffix?: string
}

const SliderField = (props: Props) => {
  const { className, title, valueField, disabled, onChangeField, onBlurField, suffix, sliderProps } = props
  const { step = 1 } = sliderProps || { step: 1 }
  return (
    <div className={className}>
      <Typography gutterBottom>{title}</Typography>
      {sliderProps && <Slider {...sliderProps} disabled={disabled} step={step} />}
      <TextField
        style={{ width: '18%' }}
        disabled={disabled}
        value={valueField}
        onChange={onChangeField}
        onBlur={onBlurField}
        InputProps={{ endAdornment: suffix && <Typography>{suffix}</Typography> }}
      />
    </div>
  )
}

export default SliderField
