import { grey } from '@material-ui/core/colors'
import { Theme } from '@material-ui/core/styles'
import { createStyles } from '@material-ui/styles'

import sharedStyles from '../shared-styles'

// eslint-disable-next-line
export default (theme: Theme) =>
  createStyles({
    ...sharedStyles(theme),
    contentContainer: { display: 'flex', justifyContent: 'center', width: '100%', height: '100%' },
    content: { display: 'flex', flexDirection: 'column', width: '100%' },
    cardsContainer: { display: 'flex' },
    list: { width: '50%', paddingLeft: theme.spacing(2) },
    listItem: { display: 'flex', justifyContent: 'center', padding: theme.spacing(1) },
    listItemIcon: { fontSize: theme.spacing(3.5) },
    avatar: { background: grey['900'] },
  })
