import React from 'react'
import { RouteComponentProps } from 'react-router'

import { List } from '@material-ui/core'
import { withStyles, WithStyles } from '@material-ui/core/styles'
import {
  CheckBox as CheckBoxIcon,
  Description as DescriptionIcon,
  Person as PersonIcon,
  Settings as SettingsIcon,
  ThumbUp as ThumbUpIcon,
  TrendingUp as TrendingUpIcon,
  VisibilityOff as VisibilityOffIcon
} from '@material-ui/icons'

import { PROPOSAL_DATA_PATHS } from '../ProposalData'
import ListItem from './ListItem'
import styles from './styles'

type ExtendedProps = WithStyles<typeof styles> & RouteComponentProps

interface Props extends ExtendedProps {}

const SelectOption = (props: Props) => {
  const { classes, history } = props

  return (
    <div className={classes.contentContainer}>
      <div className={classes.content}>
        <List component="nav" className={classes.list}>
          <ListItem
            label="Pessoas envolvidas"
            icon={<PersonIcon className={classes.listItemIcon} />}
            onClick={() => history.push(PROPOSAL_DATA_PATHS.involvedPeople)}
          />
          <ListItem
            label="Dados de negócio"
            icon={<SettingsIcon className={classes.listItemIcon} />}
            onClick={() => history.push(PROPOSAL_DATA_PATHS.businessData)}
          />
          <ListItem label="LSE" icon={<TrendingUpIcon className={classes.listItemIcon} />} />
          <ListItem label="Solicitação" icon={<ThumbUpIcon className={classes.listItemIcon} />} />
          <ListItem label="Parecer" icon={<VisibilityOffIcon className={classes.listItemIcon} />} />
          <ListItem label="Resumo" icon={<DescriptionIcon className={classes.listItemIcon} />} />
          <ListItem label="Checklist do Projeto" icon={<CheckBoxIcon className={classes.listItemIcon} />} />
        </List>
      </div>
    </div>
  )
}

export default withStyles(styles)(SelectOption)
